/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#include <Demos/demos.h>

#include <Physics/Dynamics/World/hkpPhysicsSystem.h>
#include <Physics/Dynamics/World/Util/hkpWorldCallbackUtil.h>
#include <Physics/Dynamics/Constraint/Bilateral/BallAndSocket/hkpBallAndSocketConstraintData.h>
#include <Physics/Utilities/VisualDebugger/Viewer/Dynamics/hkpConstraintViewer.h>

#include <Demos/Physics/Test/Performance/BroadphaseAddRemove/BroadphaseAddRemove.h>
#include <Common/Visualize/hkDebugDisplay.h>

#include <Graphics/Common/Input/Pad/hkgPad.h>
#include <Demos/DemoCommon/Utilities/GameUtils/GameUtils.h>

#include <Physics/Internal/BroadPhase/HybridBroadphase/hkpHybridBroadphase.h>

#define DAMPING		10.0f
#define NO_DAMPING	0.5f

static BroadphaseAddRemoveDemo::Variant	g_variants[]=
{
	{ "Dynamic/One shape/Hybrid 2048 damped", "", BroadphaseAddRemoveDemo::HYBRID, 2048, DAMPING, false, false },
	{ "Dynamic/One shape/Hybrid 2048", "", BroadphaseAddRemoveDemo::HYBRID, 2048, NO_DAMPING, false, false },
	{ "Dynamic/One shape/Kd_tree 2048 damped", "", BroadphaseAddRemoveDemo::KD_TREE, 2048, DAMPING, false, false },
	{ "Dynamic/One shape/Kd_tree 2048", "", BroadphaseAddRemoveDemo::KD_TREE, 2048, NO_DAMPING, false, false },
	
	{ "Static/One shape/Hybrid 2048 damped", "", BroadphaseAddRemoveDemo::HYBRID, 2048, DAMPING, false, true },
	{ "Static/One shape/Hybrid 2048", "", BroadphaseAddRemoveDemo::HYBRID, 2048, NO_DAMPING, false, true },
	{ "Static/One shape/Kd_tree 2048 damped", "", BroadphaseAddRemoveDemo::KD_TREE, 2048, DAMPING, false, true },
	{ "Static/One shape/Kd_tree 2048", "", BroadphaseAddRemoveDemo::KD_TREE, 2048, NO_DAMPING, false, true },
	
	{ "Dynamic/Mixed shape/Hybrid 2048 damped", "", BroadphaseAddRemoveDemo::HYBRID, 2048, DAMPING, true, false },
	{ "Dynamic/Mixed shape/Hybrid 2048", "", BroadphaseAddRemoveDemo::HYBRID, 2048, NO_DAMPING, true, false },
	{ "Dynamic/Mixed shape/Kd_tree 2048 damped", "", BroadphaseAddRemoveDemo::KD_TREE, 2048, DAMPING, true, false },
	{ "Dynamic/Mixed shape/Kd_tree 2048", "", BroadphaseAddRemoveDemo::KD_TREE, 2048, NO_DAMPING, true, false },
	
	{ "Static/Mixed shape/Hybrid 2048 damped", "", BroadphaseAddRemoveDemo::HYBRID, 2048, DAMPING, true, true },
	{ "Static/Mixed shape/Hybrid 2048", "", BroadphaseAddRemoveDemo::HYBRID, 2048, NO_DAMPING, true, true },
	{ "Static/Mixed shape/Kd_tree 2048 damped", "", BroadphaseAddRemoveDemo::KD_TREE, 2048, DAMPING, true, true },
	{ "Static/Mixed shape/Kd_tree 2048", "", BroadphaseAddRemoveDemo::KD_TREE, 2048, NO_DAMPING, true, true }
};

BroadphaseAddRemoveDemo::BroadphaseAddRemoveDemo(hkDemoEnvironment* env)
:	hkDefaultPhysicsDemo(env),
	m_rndgen(180673)
{
	m_variant	=	&g_variants[m_variantId];
	m_bpConfig	=	m_variant->m_broadphase;
	m_useBatch	=	true;
	m_draw		=	true;
	m_stop		=	false;
	m_count		=	64;
	m_maxbodies	=	m_variant->m_maxObjects;
	m_maxbodies	=	(m_maxbodies / m_count) * m_count;
	//
	// Create world
	//
	{
		hkpWorldCinfo worldinfo;
		worldinfo.setupSolverInfo(hkpWorldCinfo::SOLVER_TYPE_2ITERS_SOFT);
		worldinfo.m_gravity.set( 0, 0, 0 );		
		worldinfo.m_enableDeactivation	=	false;
		switch(m_bpConfig)
		{
		case KD_TREE:
			worldinfo.m_useKdTree			=	true;
			worldinfo.m_autoUpdateKdTree	=	true;
			break;
		
		case HYBRID:
			worldinfo.m_useHybridBroadphase =	true;
			break;
		
		default:
			break;
		}
		worldinfo.setBroadPhaseWorldSize( 200.0f );
		m_world = new hkpWorld( worldinfo );
		m_world->lock();
		// Register ALL agents (though some may not be necessary)
		hkpAgentRegisterUtil::registerAllAgents(m_world->getCollisionDispatcher());

		setAutoDisplayCachingEnabled(true);
	}	
	
	//
	// Create shape
	//

	m_shapes[0] = new hkpSphereShape(0.1f);
	m_shapes[1] = new hkpBoxShape(hkVector4(0.4f,0.1f,0.1f,0));

	//
	//	Create the collision filter
	//
	
	//
	// Setup the camera
	//
	{
		hkVector4 from(   0.0f, -20.0f, 0.0f );
		hkVector4 to  (   0.0f,   0.0f, 0.0f );
		hkVector4 up  (   0.0f,   0.0f, 1.0f );
		setupDefaultCameras( env, from, to, up );
		
		float ldir[] = { 0, 0.5f, -1.0f };
		setSoleDirectionLight(m_env, ldir, 0xffffffff );

		setupGraphics();
	}

	m_world->unlock();
}

BroadphaseAddRemoveDemo::~BroadphaseAddRemoveDemo()
{
	m_world->lock();
	m_world->removeEntityBatch( reinterpret_cast<hkArray<hkpEntity*>&>(m_bodies).begin(), m_bodies.getSize() );
	hkReferencedObject::removeReferences( m_bodies.begin(), m_bodies.getSize());
	m_world->unlock();

	hkReferencedObject::removeReferences(m_shapes, 2);
}

void			BroadphaseAddRemoveDemo::spawnFirework()
{
	HK_MONITOR_ADD_VALUE("Add count",(float)m_count, HK_MONITOR_TYPE_INT);
	hkpRigidBodyCinfo	infos;
	infos.m_motionType			=	hkpMotion::MOTION_SPHERE_INERTIA;		
	hkVector4			position;
	m_rndgen.getRandomVector11(position);
	position.mul4(5);
	m_bodies.reserve(m_bodies.getSize()+m_count);
	hkArray<hkpEntity*>	batch;
	batch.reserve(m_count);
	//
	for(int i=0;i<m_count;++i)
	{
		hkVector4			direction;
		m_rndgen.getRandomVector11(direction);
		m_rndgen.getRandomRotation(infos.m_rotation);
		infos.m_position=position;
		infos.m_position.addMul4(1.0f, direction);

		if(m_variant->m_mixedShape)
			infos.m_shape = m_shapes[m_rndgen.getRand32()%(sizeof(m_shapes)/sizeof(m_shapes[0]))];
		else
			infos.m_shape = m_shapes[0];

		hkpRigidBody*		body=new hkpRigidBody(infos);
		body->setLinearDamping(m_variant->m_damping);
		body->setAngularDamping(m_variant->m_damping*0.1f);


		if(!m_draw) body->addProperty( HK_PROPERTY_DISPLAY_SHAPE, HK_NULL );
		if(m_useBatch)
		{
			batch.pushBack(body);
		}
		else
		{
			m_world->addEntity(body);
		}

		direction.mul4(10);
		body->applyLinearImpulse(direction);
		m_bodies.pushBack(body);
	}
	if(batch.getSize())
	{
		m_world->addEntityBatch(&batch[0],batch.getSize());
	}
}

void			BroadphaseAddRemoveDemo::flushFirework()
{
	HK_MONITOR_ADD_VALUE("Remove count",(float)(m_bodies.getSize()-m_maxbodies), HK_MONITOR_TYPE_INT);
	hkArray<hkpEntity*> batch; batch.reserve(m_count);
	while(m_bodies.getSize()>m_maxbodies)
	{
		const int index = m_rndgen.getRand32()%m_bodies.getSize();
		if(m_useBatch)
		{
			batch.pushBack(m_bodies[index]);
		}
		else
		{
			m_world->removeEntity(m_bodies[index]);
			m_bodies[index]->removeReference();
		}	
		m_bodies.removeAtAndCopy(index);
	}
	if(batch.getSize())
	{
		m_world->removeEntityBatch(batch.begin(), batch.getSize());
		hkReferencedObject::removeReferences(batch.begin(), batch.getSize());
	}
}

hkDemo::Result BroadphaseAddRemoveDemo::stepDemo()
{	
	if(m_env->m_window->getKeyboard().wasKeyPressed('B'))	m_useBatch	=	!m_useBatch;
	if(m_env->m_window->getKeyboard().wasKeyPressed('E'))	m_draw		=	!m_draw;
	if(m_env->m_window->getKeyboard().wasKeyPressed('P'))	m_stop		=	!m_stop;
	if(m_env->m_window->getKeyboard().wasKeyPressed('L'))	{ m_stop = false; m_maxbodies	+=	256; }
	
	if(m_env->m_gamePad->wasButtonPressed(HKG_PAD_BUTTON_2)) m_useBatch		=	!m_useBatch;
	if(m_env->m_gamePad->wasButtonPressed(HKG_PAD_BUTTON_3)) m_maxbodies	+=	256;
	
	m_world->lock();

	if(m_world->m_useHybridBroadphase && m_env->m_window->getKeyboard().wasKeyPressed('O'))
	{
		((hkpHybridBroadPhase*)m_world->getBroadPhase())->fullOptimize();
	}
	
	if(!m_stop)
	{
		HK_TIMER_BEGIN_LIST( "DemoAddBodies", "Add" );
		spawnFirework();
		HK_TIMER_SPLIT_LIST( "Remove" );
		flushFirework();
		HK_TIMER_END_LIST();
		if(m_variant->m_stopWhenFull && m_bodies.getSize() >= m_maxbodies) m_stop = true;
	}
	
	int bpSize = 0;
	if(m_world->m_useHybridBroadphase)
	{
		bpSize = ((hkpHybridBroadPhase*)m_world->getBroadPhase())->getMemoryFootPrint();
	}
	
	m_world->unlock();
	char		text[256];
	hkString::sprintf(text,"%d bodies\n[B]atchs: %s\n[E]Draw: %s\nBroadphase size: %dKb",	m_bodies.getSize(),
																							m_useBatch?"ON":"OFF",
																							m_draw?"ON":"OFF",
																							(bpSize+512)/1024);
	m_env->m_textDisplay->outputText(text,8,(int)m_env->m_window->getHeight()-96);
	
	return hkDefaultPhysicsDemo::stepDemo();
}




static const char helpString[] =	"Broadphase.";

//HK_DECLARE_DEMO(BroadphaseAddRemoveDemo, HK_DEMO_TYPE_PHYSICS, helpString, helpString );
HK_DECLARE_DEMO_VARIANT_USING_STRUCT( BroadphaseAddRemoveDemo, HK_DEMO_TYPE_PHYSICS | HK_DEMO_TYPE_DONT_BOOTSTRAP, BroadphaseAddRemoveDemo::Variant, g_variants, HK_NULL );

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
