/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#include <Demos/demos.h>

#include <Demos/Physics/Test/Feature/Collide/AabbTree/AutoBundle/AutoBundleDemo.h>
#include <Demos/DemoCommon/Utilities/KdTree/KdTreeDemoUtils.h>

#include <Common/Internal/KdTree/hkKdTree.h>
#include <Physics/Dynamics/World/Util/KdTree/hkpKdTreeWorldManager.h>
#include <Physics/Dynamics/World/Util/AabbTree/hkpAabbTreeWorldManager.h>
#include <Common/Internal/KdTree/Build/hkKdTreeBuilder.h>
#include <Common/Internal/KdTree/Build/hkKdTreeBuildingUtils.h>
#include <Common/Internal/KdTree/QueryUtils/hkKdTreeUtils.h>

#include <Physics/Collide/Query/Collector/KdTreeCollector/hkpKdTreeCollidableRaycaster.h>
#include <Physics/Collide/Query/Collector/KdTreeCollector/hkpKdTreeWorldLinearCaster.h>
#include <Physics/Collide/Util/KdTree/Mediator/hkpCollidableMediator.h>

// Used for graphics and I/O
#include <Common/Base/Monitor/hkMonitorStream.h>
#include <Common/Base/Container/LocalArray/hkLocalArray.h>
#include <Common/Visualize/hkDebugDisplay.h>
#include <Demos/DemoCommon/Utilities/GameUtils/GameUtils.h>
#include <Demos/DemoCommon/DemoFramework/hkTextDisplay.h>

#include <Common/Visualize/hkDebugDisplay.h>
#include <Demos/DemoCommon/Utilities/KdTree/KdTreeDebugUtils.h>

// Serialization
#include <Common/Base/Container/LocalArray/hkLocalBuffer.h>

#include <Physics/Collide/Query/Collector/RayCollector/hkpClosestRayHitCollector.h>
#include <Physics/Collide/Query/CastUtil/hkpWorldRayCastInput.h>
#include <Physics/Collide/Query/CastUtil/hkpWorldRayCastOutput.h>

#include <Physics/Collide/BroadPhase/hkpBroadPhase.h>


#include <Physics/Collide/Query/Collector/PointCollector/hkpClosestCdPointCollector.h>
#include <Physics/Collide/Query/CastUtil/hkpLinearCastInput.h>
#include <Physics/Collide/Agent/hkpCollisionAgentConfig.h>
#include <Physics/Dynamics/Phantom/hkpSimpleShapePhantom.h>

#include <Graphics/Common/Font/hkgFont.h>

#include <Physics/Collide/Query/Multithreaded/RayCastQuery/Util/hkAabbTreeRaycastUtil.h>
#include <Physics/Collide/Query/Multithreaded/RayCastQuery/Util/hkTreeBundleRaycastUtil.h>
#include <Physics/Collide/Query/Multithreaded/RayCastQuery/hkpRayCastQueryJobs.h>
#include <Physics/Collide/Query/Multithreaded/RayCastQuery/Cpu/hkpCpuKdTreeRayCastJob.h>
#include <Physics/Collide/Query/Multithreaded/RayCastQuery/hkpRayCastQueryJobQueueUtils.h>


static int numBodies = 100;

AutoBundleDemo::AutoBundleDemo(hkDemoEnvironment* env)
:	hkDefaultPhysicsDemo(env), 
m_rand(1337)
{
	{
		m_worldSizeX = 20.0f;
		m_worldSizeY = 30.0f*0.25f;
		m_worldSizeZ = m_worldSizeX;
	}

	// Setup the camera and graphics
	{
		// setup the camera
		hkVector4 from(0.0f, m_worldSizeY*0.5f, m_worldSizeZ*2.0f);
		hkVector4 to  (0.0f, 0.0f,  0.0f);
		hkVector4 up  (0.0f, 1.0f,  0.0f);
		setupDefaultCameras( env, from, to, up, 1.0f, 5000.0f );
	}

	// Use only KD Tree, not the deprecated AABB tree
	const bool useMultipleTrees = false;
	{
		hkpWorldCinfo cinfo;
		cinfo.m_gravity = hkVector4::getZero();
		cinfo.m_broadPhaseWorldAabb.m_max.set( m_worldSizeX,  m_worldSizeY,  m_worldSizeZ);
		cinfo.m_broadPhaseWorldAabb.m_min.setNeg4(	cinfo.m_broadPhaseWorldAabb.m_max );
		if( useMultipleTrees )
		{
			cinfo.m_useKdTree = false;
			cinfo.m_autoUpdateKdTree = false;
			cinfo.m_useMultipleTree = true;
		}
		else
		{
			cinfo.m_useKdTree = true;
		}
		m_world = new hkpWorld(cinfo);
		m_world->lock();
	}


	{
		hkpAgentRegisterUtil::registerAllAgents(m_world->getCollisionDispatcher());
	}

	//
	// Add a lot of rigid bodies to the world
	//
	{
		hkAabb worldAabb; 
		worldAabb.m_max.set( m_worldSizeX,  m_worldSizeY,  m_worldSizeZ);
		worldAabb.m_max.mul4( 0.95f );
		worldAabb.m_min.setNeg4( worldAabb.m_max );	

		hkpMotion::MotionType motionType = hkpMotion::MOTION_BOX_INERTIA;
		KdTreeDemoUtils::createRandomBodies(m_world, worldAabb, numBodies, motionType, &m_rand, m_collidables);

		motionType = hkpMotion::MOTION_FIXED;
		KdTreeDemoUtils::createRandomBodies(m_world, worldAabb, numBodies, motionType, &m_rand, m_collidables);
	}

	if( useMultipleTrees )
	{
		hkArray<const hkpCollidable*> collidables;
		hkpAabbTreeWorldManager::gatherCollidablesFromWorld( collidables, m_world );
		m_maxNumOfObjForTree = collidables.getSize() * 4;
		m_treeManagerData.setSize( m_world->m_kdTreeManager->calcWorkingBufferSize( m_maxNumOfObjForTree ) );
		m_world->m_kdTreeManager->setWorkingBuffer( m_treeManagerData.begin() );
	}

	setupGraphics();

	m_world->unlock();

	hkpRayCastQueryJobQueueUtils::registerWithJobQueue(m_jobQueue);
}

AutoBundleDemo::~AutoBundleDemo()
{

}
void AutoBundleDemo::doRaycast()
{
	const int numRays = 4*50;

	hkArray<hkVector4> testRayFrom( numRays); // heap for spu jobs
	hkArray<hkVector4> testRayTo( numRays );// heap for spu jobs
	{
		hkAabb worldAabb; 
		worldAabb.m_max.set( m_worldSizeX,  m_worldSizeY,  m_worldSizeZ);
		worldAabb.m_min.setNeg4( worldAabb.m_max );	

		const hkReal dVariance = 0.05f;
		for(int i=0; i<numRays; i+=4)
		{
			hkVector4 from;
			hkVector4 to;

			m_rand.getRandomVectorRange( worldAabb.m_min, worldAabb.m_max, from );
			m_rand.getRandomVectorRange( worldAabb.m_min, worldAabb.m_max, to );

			KdTreeDemoUtils::makeRaysForBundle( from, to, &testRayFrom[i], &testRayTo[i], (1)*dVariance, m_rand );
		}
	}


	hkArray<hkAabbTreeData::SetRays> bundledRays;
	hkArray<hkpWorldRayCastInput> singleRays;

	hkArray<hkpWorldRayCastOutput> results( numRays );
	hkArray<hkpWorldRayCastCommand> singleCommands;
	hkArray<hkpWorldRayCastBundleCommand> bundledCommands;
	{
		hkReal angleVariance = HK_REAL_PI*7.5f/180.0f;
		hkReal distanceVariance2 = hkMath::pow(0.075f, 2.0f);

		hkSemaphoreBusyWait* semaphore = new hkSemaphoreBusyWait(0, 1000); // must be allocated on heap, for SPU to work
		hkpCollisionQueryJobHeader* jobHeader = hkAllocateChunk<hkpCollisionQueryJobHeader>(1, HK_MEMORY_CLASS_DEMO);

		singleCommands.reserve( 8*numRays );
		bundledCommands.reserve( 8*numRays );

		m_world->markForRead();
		//	create world raycast job to pass to startWorldRayCastWithAutoBundleJobs
 		hkpWorldRayCastJob worldRayCastJob(m_world->getCollisionInput(), jobHeader, singleCommands.begin(), 0, HK_NULL, semaphore);
		{
			worldRayCastJob.m_aabbTreeInt16 = m_world->m_kdTreeManager->m_inactiveTree;
			worldRayCastJob.m_kdTree = m_world->m_kdTreeManager->m_kdTree;
			worldRayCastJob.m_bundleCommandArray = bundledCommands.begin();
		}

		//	on PlayStation(R)3 all scan is faster than binning
		{
			HK_TIMER_BEGIN("RaycastAutoBundle[CPUBinning]",0);
			hkTreeBundleRayCastUtil::startWorldRayCastWithAutoBundleJobs(testRayFrom.begin(), testRayTo.begin(), numRays, angleVariance, distanceVariance2,
				&worldRayCastJob, m_jobQueue, m_jobThreadPool,
				results.begin(),  false);
			HK_TIMER_END();
		}
		if(0)
		{
			HK_TIMER_BEGIN("RaycastAutoBundle[CPUAssembly]",0);
			for(int ioc=0; ioc<8; ioc++)
			{
				int numSC, numBC;
				hkTreeBundleRayCastUtil::autoBundleScanAll(ioc, testRayFrom.begin(), testRayTo.begin(), numRays, angleVariance, distanceVariance2,
					results.begin(), singleCommands.begin()+ioc*numRays, numSC, bundledCommands.begin()+ioc*numRays, numBC);

				hkpWorldRayCastJob raycastJob( worldRayCastJob.m_collisionInput, worldRayCastJob.m_sharedJobHeaderOnPpu, 
					singleCommands.begin()+ioc*numRays, numSC, HK_NULL, worldRayCastJob.m_semaphore);
				raycastJob.m_aabbTreeInt16 = worldRayCastJob.m_aabbTreeInt16;
				raycastJob.m_kdTree = worldRayCastJob.m_kdTree;
				raycastJob.m_bundleCommandArray = bundledCommands.begin()+ioc*numRays;
				raycastJob.m_numBundleCommands = numBC;
				
				m_jobQueue->addJob( raycastJob, hkJobQueue::JOB_HIGH_PRIORITY);
			}
			m_jobThreadPool->processAllJobs( m_jobQueue );
			m_jobThreadPool->waitForCompletion();
			worldRayCastJob.m_semaphore->acquire();
			HK_TIMER_END();
		}

		m_world->unmarkForRead();

		hkDeallocateChunk(jobHeader, 1, HK_MEMORY_CLASS_DEMO);
		delete semaphore;
	}

	{
		hkSemaphoreBusyWait* semaphore = new hkSemaphoreBusyWait(0, 1000); // must be allocated on heap, for SPU to work
		hkpCollisionQueryJobHeader* jobHeader = hkAllocateChunk<hkpCollisionQueryJobHeader>(1, HK_MEMORY_CLASS_DEMO);

		hkArray<hkpWorldRayCastCommand> commands( numRays );
		hkArray<hkpWorldRayCastOutput> commandResults(numRays);

		HK_TIMER_BEGIN_LIST("RaycastSingle", "Prepare");

		for(int i=0; i<numRays; i++)
		{
			hkpWorldRayCastCommand& command = commands[i];
			command.m_rayInput.m_from = testRayFrom[i];
			command.m_rayInput.m_to = testRayTo[i];
			commandResults[i].reset();
			command.m_results = &commandResults[i];
			command.m_resultsCapacity = 1;
			command.m_numResultsOut = 0;
			command.m_stopAfterFirstHit = false;
		}

		m_world->markForRead();
		hkpWorldRayCastJob worldRayCastJob(m_world->getCollisionInput(), jobHeader, commands.begin(), commands.getSize(), HK_NULL, semaphore);
		m_world->unmarkForRead();

		m_world->lockReadOnly();
		{
			worldRayCastJob.m_aabbTreeInt16 = m_world->m_kdTreeManager->getAabbTree();
			worldRayCastJob.m_kdTree = m_world->m_kdTreeManager->getKdTree();
		}

		HK_TIMER_SPLIT_LIST("RayCast");

		m_jobQueue->addJob( worldRayCastJob, hkJobQueue::JOB_LOW_PRIORITY );
		m_jobThreadPool->processAllJobs( m_jobQueue );
		m_jobThreadPool->waitForCompletion();
		semaphore->acquire();
		HK_TIMER_END_LIST();

		m_world->unlockReadOnly();

		hkDeallocateChunk(jobHeader, 1, HK_MEMORY_CLASS_DEMO);
		delete semaphore;
	}




	//	show results

	m_world->lock();
	{
		for(int i=0; i<numRays; i++)
		{
			hkpWorldRayCastOutput checkOutput;
			{
				hkpWorldRayCastInput checkInput;
				checkInput.m_from = testRayFrom[i];
				checkInput.m_to = testRayTo[i];
				checkInput.m_filterInfo = 0;

				m_world->castRay(checkInput, checkOutput);
			}

//			HK_ASSERT(0x7cb60e18, checkOutput.hasHit() == results[i].hasHit() );

			if( checkOutput.hasHit() != results[i].hasHit() )
			{
				const hkpCollidable* col = HK_NULL;
				if( checkOutput.hasHit() ) col = checkOutput.m_rootCollidable;
				else if( results[i].hasHit() ) col = results[i].m_rootCollidable;
				HK_ASSERT( 0, col );

				hkAabb aabb;
				col->getShape()->getAabb( col->getTransform(), 0.0f, aabb );
				HK_DISPLAY_BOUNDING_BOX( aabb, hkColor::RED );

// 				if( singleRayIdx.indexOf(i) != -1 )
// 					HK_DISPLAY_LINE(testRayFrom[i], testRayTo[i], hkColor::ORANGE);
// 				else
					HK_DISPLAY_LINE(testRayFrom[i], testRayTo[i], hkColor::RED);
			}
			else if( results[i].hasHit() )
			{
				const hkpCollidable* col = results[i].m_rootCollidable;
				hkAabb aabb;
				col->getShape()->getAabb( col->getTransform(), 0.0f, aabb );
				HK_DISPLAY_BOUNDING_BOX( aabb, hkColor::BLUE );

// 				if( singleRayIdx.indexOf(i) != -1 )
// 					HK_DISPLAY_LINE(testRayFrom[i], testRayTo[i], hkColor::GREEN);
// 				else
					HK_DISPLAY_LINE(testRayFrom[i], testRayTo[i], hkColor::BLUE);
			}
			else
			{
				HK_DISPLAY_LINE(testRayFrom[i], testRayTo[i], hkColor::SLATEGRAY);
			}
		}
	}

	m_world->unlock();
}

hkDemo::Result AutoBundleDemo::stepDemo()
{
	if (m_jobThreadPool->getNumThreads() == 0)
	{
		HK_WARN(0x34561f23, "This demo does not run with only one thread");
		return DEMO_STOP;
	}

	m_rand.setSeed( m_physicsStepCounter / 10 );

	hkDemo::Result res = hkDefaultPhysicsDemo::stepDemo();


	m_world->markForRead();

	m_world->updateKdTree( );//m_jobQueue, m_jobThreadPool );

	m_world->unmarkForRead();


	doRaycast();

	return res;
}


static const char helpString[] = \
"This demo shows the usage of autobundle. Single rays hit are displayed with green, bundled rays hit are displayed in blue. The criteria to bundle rays are set high for test. ";

HK_DECLARE_DEMO(AutoBundleDemo, HK_DEMO_TYPE_PHYSICS, "BundleDemo", helpString);

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
