/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#include <Demos/demos.h>

#include <Demos/Physics/Test/Feature/Collide/AabbTree/AddDelete/AddDeleteDemo.h>
#include <Demos/DemoCommon/Utilities/KdTree/KdTreeDemoUtils.h>

#include <Common/Internal/KdTree/hkKdTree.h>
#include <Physics/Dynamics/World/Util/KdTree/hkpKdTreeWorldManager.h>
#include <Physics/Dynamics/World/Util/AabbTree/hkpAabbTreeWorldManager.h>
#include <Common/Internal/KdTree/Build/hkKdTreeBuilder.h>
#include <Common/Internal/KdTree/Build/hkKdTreeBuildingUtils.h>
#include <Common/Internal/KdTree/QueryUtils/hkKdTreeUtils.h>

#include <Physics/Collide/Query/Collector/KdTreeCollector/hkpKdTreeCollidableRaycaster.h>
#include <Physics/Collide/Query/Collector/KdTreeCollector/hkpKdTreeWorldLinearCaster.h>
#include <Physics/Collide/Util/KdTree/Mediator/hkpCollidableMediator.h>

// Used for graphics and I/O
#include <Common/Base/Monitor/hkMonitorStream.h>
#include <Common/Base/Container/LocalArray/hkLocalArray.h>
#include <Common/Visualize/hkDebugDisplay.h>
#include <Demos/DemoCommon/Utilities/GameUtils/GameUtils.h>
#include <Demos/DemoCommon/DemoFramework/hkTextDisplay.h>

#include <Common/Visualize/hkDebugDisplay.h>
#include <Demos/DemoCommon/Utilities/KdTree/KdTreeDebugUtils.h>

// Serialization
#include <Common/Base/Container/LocalArray/hkLocalBuffer.h>


#include <Physics/Collide/Query/Collector/RayCollector/hkpClosestRayHitCollector.h>
#include <Physics/Collide/Query/CastUtil/hkpWorldRayCastInput.h>
#include <Physics/Collide/Query/CastUtil/hkpWorldRayCastOutput.h>

#include <Physics/Collide/BroadPhase/hkpBroadPhase.h>


#include <Physics/Collide/Query/Collector/PointCollector/hkpClosestCdPointCollector.h>
#include <Physics/Collide/Query/CastUtil/hkpLinearCastInput.h>
#include <Physics/Collide/Agent/hkpCollisionAgentConfig.h>
#include <Physics/Dynamics/Phantom/hkpSimpleShapePhantom.h>

#include <Graphics/Common/Font/hkgFont.h>



static int numBodies = 10;



struct AddDeleteDemoVariant
{
	const char* m_name;
	const char*  m_details;

	hkpWorldCinfo::TreeUpdateType m_treeConfig;
	bool m_raycast;
};

static const AddDeleteDemoVariant g_variants[] = 
{
	{"Active:Inactive = KDTree:AabbTree", "Active:Inactive = KDTree:AabbTree", hkpWorldCinfo::REBUILD_ACTIVE, true},
//	{"AabbTreeOnly", "AabbTreeOnly", hkpAabbTreeWorldManager::INC, true},
	{"KDTreeOnly", "KDTreeOnly", hkpWorldCinfo::REBUILD_ALL, true},
};

AddDeleteDemo::AddDeleteDemo(hkDemoEnvironment* env)
:	hkDefaultPhysicsDemo(env), 
	m_rand(1337)
{

	{
		m_worldSizeX = 2.0f * hkMath::sqrt(hkReal(m_env->m_cpuMhz));
		m_worldSizeY = 30.0f;
		m_worldSizeZ = m_worldSizeX;
	}

	// Setup the camera and graphics
	{
		// setup the camera
		hkVector4 from(0.0f, m_worldSizeY*0.5f, -m_worldSizeZ*2.0f);
		hkVector4 to  (0.0f, 0.0f,  0.0f);
		hkVector4 up  (0.0f, 1.0f,  0.0f);
		setupDefaultCameras( env, from, to, up, 1.0f, 5000.0f );
	}


	{
		hkpWorldCinfo cinfo;
		cinfo.m_broadPhaseWorldAabb.m_max.set( m_worldSizeX,  m_worldSizeY,  m_worldSizeZ);
		cinfo.m_broadPhaseWorldAabb.m_min.setNeg4(	cinfo.m_broadPhaseWorldAabb.m_max );	
		cinfo.m_useMultipleTree = true;
		cinfo.m_treeUpdateType = g_variants[m_variantId].m_treeConfig;
		m_world = new hkpWorld(cinfo);
		m_world->lock();
	}


	{
		hkpAgentRegisterUtil::registerAllAgents(m_world->getCollisionDispatcher());
	}

	//
	// Add a lot of rigid bodies to the world
	//
	{
		hkAabb worldAabb; 
		worldAabb.m_max.set( m_worldSizeX,  m_worldSizeY,  m_worldSizeZ);
		worldAabb.m_max.mul4( 0.5f );
		worldAabb.m_min.setNeg4( worldAabb.m_max );	

		hkpMotion::MotionType motionType = hkpMotion::MOTION_BOX_INERTIA;
		KdTreeDemoUtils::createRandomBodies(m_world, worldAabb, numBodies, motionType, &m_rand, m_collidables);

		{		
			hkVector4 size( m_worldSizeX*2, m_worldSizeY*2 * 0.1f, m_worldSizeZ*2 );

			hkVector4 position;
			position.setZero4();
			position(1) = -m_worldSizeY;
			hkpRigidBody* rb = GameUtils::createBox( size, 0, position );
			rb->setCollisionFilterInfo( hkpGroupFilter::calcFilterInfo( hkpGroupFilterSetup::LAYER_STATIC ) );

			m_world->addEntity( rb );
			rb->removeReference();
		}

	}

	hkArray<const hkpCollidable*> collidables;
	hkpAabbTreeWorldManager::gatherCollidablesFromWorld( collidables, m_world );
	m_maxNumOfObjForTree = collidables.getSize() * 4;
	m_treeManagerData.setSize( m_world->m_kdTreeManager->calcWorkingBufferSize( m_maxNumOfObjForTree ) );
	m_world->m_kdTreeManager->setWorkingBuffer( m_treeManagerData.begin() );

	setupGraphics();
	
	m_world->unlock();

	m_counter = 0;
	m_deleteObj = true;
}

AddDeleteDemo::~AddDeleteDemo()
{
}

void AddDeleteDemo::addDeleteBodies()
{
	int interval = 25;
	int maxObjects = hkMath::min2(10, m_maxNumOfObjForTree);

	m_world->lock();
	
	if( m_collidables.getSize() == 0 )
	{
		m_deleteObj = false;
	}
	if( m_collidables.getSize() > maxObjects )
	{
		m_deleteObj = true;
	}

	if( m_counter % interval == interval-1 )
	{
		if( m_deleteObj )
		{
			if( m_collidables.getSize() )
			{
				hkpRigidBody* rb = hkpGetRigidBody( m_collidables[0] );
				if( rb )
				{
					m_world->removeEntity( rb );
					m_collidables.removeAt( 0 );
				}
				else
				{
					hkpPhantom* p = hkpGetPhantom( m_collidables[0] );
					if( p )
					{
						m_world->removePhantom( p );
						m_collidables.removeAt( 0 );
					}
				}
			}
		}
		else
		{
			if( m_collidables.getSize() < m_maxNumOfObjForTree-1 )
			{
				int addType = m_rand.getRandInt16(2);

				hkAabb worldAabb; 
				worldAabb.m_max.set( m_worldSizeX,  m_worldSizeY,  m_worldSizeZ);
				worldAabb.m_max.mul4( 0.5f );
				worldAabb.m_min.setNeg4( worldAabb.m_max );	

				if( addType == 0)
				{

					//				createRandomBodies(m_world, space, numBodies, worldSize * 0.0025f ,hkpMotion::MOTION_BOX_INERTIA, &m_rand, m_collidables);
					KdTreeDemoUtils::createRandomBodies(m_world, worldAabb, 1, hkpMotion::MOTION_BOX_INERTIA, &m_rand, m_collidables);
				}
				else
				{
					hkVector4 t;
					m_rand.getRandomVectorRange(worldAabb.m_min, worldAabb.m_max, t);

					hkpSphereShape* sp = new hkpSphereShape(2.0f);
					hkTransform transform;
					transform.setIdentity();
					transform.getTranslation() = t;
					hkpSimpleShapePhantom* phantom = new hkpSimpleShapePhantom( sp, transform );
					m_world->addPhantom( phantom );

					m_collidables.pushBack( phantom->getCollidable() );

					sp->removeReference();

					phantom->removeReference();
				}
			}
		}
	}


	m_world->unlock();
}


hkDemo::Result AddDeleteDemo::stepDemo()
{
	const hkgKeyboard& keys = m_env->m_window->getKeyboard();

	if( keys.wasKeyPressed('I'))
	{
		m_deleteObj = !m_deleteObj;
	}


	m_counter ++;

	hkDemo::Result res = hkDefaultPhysicsDemo::stepDemo();

	addDeleteBodies();

	m_world->markForRead();

	m_world->updateKdTree( m_jobQueue, m_jobThreadPool );


	{
		hkpAabbTreeWorldManager* manager = static_cast< hkpAabbTreeWorldManager*>(m_world->m_kdTreeManager);
		manager->checkConsistency();
	}

	m_world->unmarkForRead();


		//	text
	{
		hkpAabbTreeWorldManager* aabbTreeManager = static_cast<hkpAabbTreeWorldManager*>(m_world->m_kdTreeManager);
		const hkArray<const hkpCollidable*>& activeList = aabbTreeManager->getActiveList();
		hkArray<const hkpCollidable*> allObjList;
		m_world->markForRead();
		hkpAabbTreeWorldManager::gatherCollidablesFromWorld( allObjList, m_world );
		m_world->unmarkForRead();

		const int numLines = 2;
		char text[32*numLines];
		hkString::sprintf( text, "<<AabbTreeManager>>\nNum Active : %d\nNum Inactive : %d",
			activeList.getSize(), allObjList.getSize() - activeList.getSize() );
		float x = 20.f;
		float y = m_env->m_window->getHeight() - 50.f - numLines*m_env->m_textDisplay->getFont()->getCharHeight();
		m_env->m_textDisplay->outputText(text, x, y, 0xffffffff, 1, 0);

	}

	return res;
}


static const char helpString[] = \
"This demo tests the function of addition and deletion of objects to the scene using aabbTreeWorldManager.";

HK_DECLARE_DEMO_VARIANT_USING_STRUCT( AddDeleteDemo, HK_DEMO_TYPE_PHYSICS, AddDeleteDemoVariant, g_variants, helpString );

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
