/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_BUOYANCY_H
#define HK_BUOYANCY_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysicsDemo.h>
#include <Demos/Physics/Api/Dynamics/Actions/BuoyancyAction/BuoyancyAction.h>

class BuoyancyDemo : public hkDefaultPhysicsDemo
{
public:

	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

								BuoyancyDemo(hkDemoEnvironment* env);
								~BuoyancyDemo();
	hkDemo::Result				stepDemo();
	hkReal						evaluateWaveFunction(const hkVector4& xz) const;
	void						evaluateWaveFunctionDerivative(const hkVector4& xz, hkVector4& planeOut) const;
	void						recurseDrawWater(const hkVector4& a,const hkVector4& b,const hkVector4& c, int depth) const;
	void						drawWater(const hkVector4& a,const hkVector4& b,const hkVector4& c, int depth) const;

	BuoyancyAction::Environment*	m_environment;
	hkReal							m_timeAccumulator;
};

#endif // HK_BUOYANCY_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
