/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_CONSTRAINT_SOLVER_DEMO_H
#define HK_CONSTRAINT_SOLVER_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysicsDemo.h>
#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>

//
///	Testbed for constraint solvers

class SolverDemo : public hkDefaultPhysicsDemo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

	public:

		struct TextInfo
		{
			HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, SolverDemo::TextInfo);

			hkStringPtr m_text;
			hkVector4 m_pos;
			hkUint32 m_color;
		};

	public:

		SolverDemo(hkDemoEnvironment* env);
		~SolverDemo();
		Result stepDemo(); 

			/// Key handler
		int keyHandler(char key);

	protected:

			/// Creates the ground
		void createGround(const hkVector4& vSizes, const hkVector4& vPos);

			/// Creates a chain
		hkpRigidBody* createBallSocketChain(const int numLinks, const hkReal linkSize,
											const hkVector4& rootPos, const hkVector4& chainDir,
											const hkQuaternion& deltaLinkRot, 
											const hkReal linkMass, const hkReal endEffectorMass, const hkReal materialDensity, const hkReal initialHeight);

			/// Creates a chain of rigid bodies
		void createBodiesChain(	const int numLinks, const hkReal jointSize,
								const hkVector4& rootPos, const hkVector4& chainDir,
								const hkQuaternion& deltaLinkRot, 
								const hkReal linkMass, const hkReal endEffectorMass, const hkReal materialDensity, hkArray<hkpRigidBody*>& bodiesOut);

			/// Adds a text for display
		void addText(const char* text, const hkVector4& vPos, const hkUint32 color);

			/// Randomizes a rigid body
		void randomizeBody(hkpRigidBody* rb);

			/// Toggles the solver from/to stable to/from fast 
		void toggleSolver();

	private:

			// Random number generator
		hkPseudoRandomGenerator m_rng;

			// Array of text to display
		hkArray<TextInfo> m_texts;

			// True if texts are to be displayed
		hkBool m_showTexts;

			/// Current motor angle
		hkReal m_currentMotorAngle;
		hkReal m_motorAngleVel;

			/// Current motor position
		hkReal m_currentMotorPos;
		hkReal m_motorPosVel;

			/// Current solver method
		hkBool m_stableSolverOn;
};

#endif	// HK_CONSTRAINT_SOLVER_DEMO_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
