/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_CONSTRAINT_DATA_CHECK_DEMO_H
#define HK_CONSTRAINT_DATA_CHECK_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysicsDemo.h>
#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>

//
///	Tests all the constraint atoms for validity / proper padding

class ConstraintDataCheckDemo : public hkDefaultPhysicsDemo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

	public:

		ConstraintDataCheckDemo(hkDemoEnvironment* env);
		~ConstraintDataCheckDemo();

	protected:

			/// Checks if all constraint data have proper padding
		void checkConstraintData();

			///	Checks whether the given member is an atoms struct
		hkBool isAtomsStruct(const class hkClassMember& member);

			/// Checks whether the atom offsets are valid
		hkBool checkAtomOffsets(const class hkClass* atomsClass);

			/// Prints a debug message
		void dbgOut(const char* str);

			/// Lists all the atom classes
		void listAtoms();

			/// Locates the constraint atom lists classes
		void findAtomLists(hkArray<const hkClass*>& classesOut);

			/// Checks whether the atom lists containing a ball & socket part also have a SetupStabilizationAtom
		void checkBallSockets(const hkArray<const hkClass*>& ballSocketsIn);

			/// Keeps only the atom lists containing a member of atomClassFilter
		void filterAtomLists(const hkArray<const hkClass*>& atomListsIn, const hkClass* atomClassFilter, hkArray<const hkClass*>& classesOut);

			/// Returns true if the given class is abstract
		hkBool isAbstractClass(const class hkClass* klass);

	private:

			/// True if we're to provide extensive messages
		hkBool m_verbose;
};

#endif	// HK_CONSTRAINT_DATA_CHECK_DEMO_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
