/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_LANDSCAPE_DEMO_UTIL_H
#define HK_LANDSCAPE_DEMO_UTIL_H

#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>

class hkpShape;
class hkpCompressedMeshShape;
class hkpExtendedMeshShape;
class hkpMoppBvTreeShape;
class hkpBoxShape;
class hkpListShape;
class hkpTriSampledHeightFieldBvTreeShape;
class hkpRigidBodyCinfo;

#define DEFAULT_ERROR 0.001f
#define DEFAULT_SIDES_OF_SIMPLE_LANDSCAPE 32
#define DEFAULT_NUM_VERTICES_CONVEX_PIECE 15
#define DEFAULT_SCALE_SIMPLE_LANDSCAPE 5.0f
#define DEFAULT_CONVEX_RADIUS 0.01f
#define DEFAULT_RANDOM_SEED 14

/// A utility to construct some standard landscapes for our demos.
/// Because some of the shapes don't manage the memory of "external data", the utility object
/// must be kept around until objects created with it have been finished with.
class LandscapeDemoUtil : public hkReferencedObject
{
	public:
		HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO );

			/// Defines the type of shape built.
		enum LandscapeShape
		{
				/// An hkpCompressedMeshShape
			LANDSCAPE_IS_CMS,
				/// An hkpExtendedMeshShape
			LANDSCAPE_IS_EMS,
				/// An height field.
			LANDSCAPE_IS_HEIGHT_FIELD,
		};

			/// Defines the source of the landscape data.
		enum LandscapeSource
		{
				/// A simple undulating landscape.
			LANDSCAPE_SOURCE_IS_SIMPLE,
				/// A more complex landscape with a castle.
			LANDSCAPE_SOURCE_IS_CASTLE
		};

			/// Filter layers for a material table in the landscape (see hkpGroupFilter).
		enum FilterLayers
		{
			GROUND_LAYER = 1,
			BOX_LAYER
		};

	public:
		LandscapeDemoUtil();

		~LandscapeDemoUtil();

			/// Obtain a cinfo for creating a rigid body of the landscape.
		void setLandscapeBodyCinfo( LandscapeShape landscapeShape, LandscapeSource landscapeSource, hkpRigidBodyCinfo& infoOut );

			/// Obtain a landscape shape.
		const hkpShape* createLandscapeShape( LandscapeShape landscapeShape, LandscapeSource landscapeSource );

	public:
		// Internal

			/// Use a simple undulating landscape.
		const hkpShape* createSimpleLandscapeShape( LandscapeShape landscapeShape );

		hkpCompressedMeshShape* createSimpleCompressedMeshShape();
		hkpExtendedMeshShape* createSimpleExtendedMeshShape();
		hkpTriSampledHeightFieldBvTreeShape* createSimpleHeightFieldShape();

		const hkpShape* createCastleLandscapeShape( LandscapeShape landscapeShape );
		const hkpShape* loadFirstShapeInAsset( const char* filename );
		hkpCompressedMeshShape* createCastleCompressedMeshShape();
		const hkpShape* createCastleExtendedMeshShape();

		static hkReal wavyFunction( int i, int j );
		void createWavySurface( const int side, hkGeometry& geometry ) const;
	
		hkpMoppBvTreeShape* createMoppShape( hkpShapeCollection* meshShape, bool useChunks );

		hkUint32 getCollisionFilterInfoIndex( int index ) const;

	public:
			/// The quantization error used in compression.
		hkReal m_error;

			/// Determines the complexity of the simple landscape.
		int m_simpleLandscapeNumSides;

		hkReal m_simpleLandscapeScale;
		
			/// If 0, then no convex piece is added to simple landscapes.
		int m_numVerticesConvexPiece;

		hkReal m_convexRadius;

			/// If size 0, no filter infos are used. If size >=0, then collision filter infos
			/// will be distributed in the landscape.
		hkArray<hkUint32> m_collisionFilterInfos;

		hkPseudoRandomGenerator m_random;
	private:
			/// This object may need to manage the memory of "external data" for shapes it
			/// created.
		hkArray<hkReferencedObject*> m_externalData;
};

#endif // HK_LANDSCAPE_DEMO_UTIL_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
