/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_FALLING_BODY_DEMO_UTIL_H
#define HK_FALLING_BODY_DEMO_UTIL_H

#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>

class hkpShape;
class hkpCompoundShape;
class hkpBoxShape;
class hkpListShape;
class hkpRigidBodyCinfo;

#define DEFAULT_NUM_VERTICES_CONVEX_PIECE 15
#define DEFAULT_CONVEX_RADIUS 0.01f
#define DEFAULT_RANDOM_SEED 14
#define DEFAULT_FALLING_BOX_SHAPE_SIZE 1.0f
#define DEFAULT_FALLING_BODY_MASS 1.0f

#define USE_CONVEX_DECOMPOSITION_FOR_COMPOUND 0

/// A utility to construct some standard landscapes for our demos.
/// Because some of the shapes don't manage the memory of "external data", the utility object
/// must be kept around until objects created with it have been finished with.
class FallingBodyDemoUtil : public hkReferencedObject
{
	public:
		HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO );

			/// The kind of objects to collide with the landscape.
		enum FallingBodyShape
		{
				/// A sphere.
			FALLING_BODIES_ARE_SPHERES,
				/// A box.
			FALLING_BODIES_ARE_BOXES,
				/// A composite bodies which is a list shape.
			FALLING_BODIES_ARE_LISTS,
		};

	public:
		FallingBodyDemoUtil();

		~FallingBodyDemoUtil();

			/// Sets the shape, mass properties and motion type. Remember to remove the reference
			/// of the shape after you've added created rigid bodies.
		void setFallingBodyCinfo( FallingBodyShape fallingBodyShape, hkpRigidBodyCinfo& infoOut );

	public:
		// Internal

		void setFallingBoxCinfo( hkpRigidBodyCinfo& infoOut );
		void setFallingSphereCinfo( hkpRigidBodyCinfo& infoOut );
		void setFallingListCinfo( hkpRigidBodyCinfo& infoOut );

	public:
			/// If 0, then no convex piece is added to simple landscapes.
		int m_numVerticesConvexPiece;

		hkReal m_convexRadius;

			/// You can set the seed on this after construction.
		hkPseudoRandomGenerator m_random;

			/// The size of one side of a falling cube.
		hkReal m_fallingBodySize;

			/// The mass of a falling body.
		hkReal m_fallingBodyMass;

	private:
			/// This object may need to manage the memory of "external data" for shapes it
			/// created.
		hkArray<hkReferencedObject*> m_externalData;
};

#endif // HK_FALLING_BODY_DEMO_UTIL_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
