/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#include <Demos/demos.h>
#include <Demos/Physics/Api/Collide/Shapes/Landscape/LandscapeComparison/FallingBodyDemoUtil.h>

// Shapes
#include <Physics/Collide/Shape/Compound/Collection/List/hkpListShape.h>
#include <Physics/Collide/Shape/Convex/Box/hkpBoxShape.h>
#include <Physics/Collide/Shape/Convex/Sphere/hkpSphereShape.h>
#include <Physics/Collide/Shape/Convex/ConvexTranslate/hkpConvexTranslateShape.h>

// Shape building.
#include <Common/Base/Types/Geometry/hkStridedVertices.h>

// Misc utils
#include <Demos/DemoCommon/Utilities/GameUtils/GameUtils.h>

#define SUB_SPHERE_RADIUS_FACTOR 0.2f

FallingBodyDemoUtil::FallingBodyDemoUtil()
: m_numVerticesConvexPiece( DEFAULT_NUM_VERTICES_CONVEX_PIECE )
, m_convexRadius( DEFAULT_CONVEX_RADIUS )
, m_random( DEFAULT_RANDOM_SEED )
, m_fallingBodySize( DEFAULT_FALLING_BOX_SHAPE_SIZE )
, m_fallingBodyMass( DEFAULT_FALLING_BODY_MASS )
{
}

FallingBodyDemoUtil::~FallingBodyDemoUtil()
{
	hkReferencedObject::removeReferences( m_externalData.begin(), m_externalData.getSize() );
}

void FallingBodyDemoUtil::setFallingBodyCinfo( FallingBodyShape fallingBodyShape, hkpRigidBodyCinfo& infoOut )
{
	switch ( fallingBodyShape )
	{
		case FALLING_BODIES_ARE_BOXES:
			return setFallingBoxCinfo( infoOut );
		case FALLING_BODIES_ARE_SPHERES:
			return setFallingSphereCinfo( infoOut );
		case FALLING_BODIES_ARE_LISTS:
			return setFallingListCinfo( infoOut );
		default:
			HK_ASSERT( 0x241f7f2, false );
	}
}

void FallingBodyDemoUtil::setFallingBoxCinfo( hkpRigidBodyCinfo& infoOut )
{
	hkVector4 halfExtents; 
	{
		halfExtents.setAll( m_fallingBodySize );
		halfExtents.mul4( 0.5f );
	}
	
	infoOut.m_shape = new hkpBoxShape( halfExtents );
	infoOut.m_mass = m_fallingBodyMass;
	infoOut.m_motionType = hkpMotion::MOTION_BOX_INERTIA;
	infoOut.m_qualityType = HK_COLLIDABLE_QUALITY_CRITICAL;
	{
		hkpMassProperties massProperties;
		{
			hkpInertiaTensorComputer::computeBoxVolumeMassProperties( halfExtents, m_fallingBodyMass, massProperties );
		}
		infoOut.m_inertiaTensor = massProperties.m_inertiaTensor;
		infoOut.m_centerOfMass = massProperties.m_centerOfMass;
	}
}

void FallingBodyDemoUtil::setFallingSphereCinfo( hkpRigidBodyCinfo& infoOut )
{
	infoOut.m_shape = new hkpSphereShape( m_fallingBodySize );
	infoOut.m_mass = m_fallingBodyMass;
	infoOut.m_motionType = hkpMotion::MOTION_SPHERE_INERTIA;
	infoOut.m_qualityType = HK_COLLIDABLE_QUALITY_CRITICAL;
	{
		hkpMassProperties massProperties;
		{
			hkpInertiaTensorComputer::computeSphereVolumeMassProperties( m_fallingBodySize, m_fallingBodyMass, massProperties );
		}
		infoOut.m_inertiaTensor = massProperties.m_inertiaTensor;
		infoOut.m_centerOfMass = massProperties.m_centerOfMass;
	}
}

void FallingBodyDemoUtil::setFallingListCinfo( hkpRigidBodyCinfo& infoOut )
{
#if USE_CONVEX_DECOMPOSITION_FOR_COMPOUND
	hkpListShape* list = static_cast<hkpListShape*>( CompoundShapeConverterCD::createCompoundShapeFromDecomposedGeometry(	"Resources/Physics/Concaves/GreekChair.hkt",
																							2.0f,
																							0.1f,
																							CompoundShapeConverterCD::LIST_SHAPE) );

	hkpMassProperties	massProperties;
	hkpInertiaTensorComputer::computeShapeVolumeMassProperties(list, m_fallingBodyMass, massProperties);

	infoOut.setMassProperties(massProperties);
	infoOut.m_shape			=	list;
	infoOut.m_restitution	=	0.0f;
	infoOut.m_motionType	=	hkpMotion::MOTION_DYNAMIC;
	infoOut.m_qualityType	=	HK_COLLIDABLE_QUALITY_CRITICAL;
#else
	const hkReal sphereRadius = m_fallingBodySize * SUB_SPHERE_RADIUS_FACTOR;
	const hkReal sphereTranslationDistance = m_fallingBodySize * ( 0.5f - SUB_SPHERE_RADIUS_FACTOR );

	hkpSphereShape* sphere = new hkpSphereShape( sphereRadius );

	hkInplaceArray<hkpMassElement, 8> massElements;

	hkpMassProperties sphereMassProperties;
	hkpInertiaTensorComputer::computeSphereVolumeMassProperties( sphereRadius, m_fallingBodyMass, sphereMassProperties );

	hkpShape* shapes[8];
	for (int i = 0; i < 8; i++)
	{
		hkReal px = i&0x1 ? -sphereTranslationDistance : sphereTranslationDistance;
		hkReal py = i&0x2 ? -sphereTranslationDistance : sphereTranslationDistance;
		hkReal pz = i&0x4 ? -sphereTranslationDistance : sphereTranslationDistance;

		hkVector4 translation( px, py, pz );

		shapes[i] = new hkpConvexTranslateShape( sphere, translation );

		hkpMassElement& me = massElements.expandOne();
		me.m_properties = sphereMassProperties;
		me.m_transform.setTranslation( translation );
		me.m_transform.setRotation( hkQuaternion::getIdentity() );
	}
	sphere->removeReference();

	hkpListShape* list = new hkpListShape( shapes, 8 );
	hkReferencedObject::removeReferences( shapes, 8 );
	
	infoOut.m_shape = list;
	infoOut.m_mass = m_fallingBodyMass;

	hkpMassProperties compoundMassProperties;
	hkInertiaTensorComputer::combineMassProperties( massElements, compoundMassProperties );

	infoOut.m_motionType = hkpMotion::MOTION_DYNAMIC;
	infoOut.m_qualityType = HK_COLLIDABLE_QUALITY_CRITICAL;
	infoOut.m_centerOfMass = compoundMassProperties.m_centerOfMass;
	infoOut.m_inertiaTensor = compoundMassProperties.m_inertiaTensor;
#endif

	// Set collision filter info for the children to use the collidable's collision filter info.
	for ( hkpShapeKey key = list->getFirstKey(); key != HK_INVALID_SHAPE_KEY; key = list->getNextKey( key ) )
	{
		list->setCollisionFilterInfo( key, hkUint32( hkpGroupFilter::USE_COLLIDABLE_FILTER_INFO ) );
	}
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
