/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */


#ifndef HK_CompressedMeshDemo_H
#define HK_CompressedMeshDemo_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysicsDemo.h>
#include <Physics/Collide/Shape/Compound/Collection/CompressedMesh/hkpCompressedMeshShape.h>
#include <Physics/Collide/Shape/Compound/Collection/CompressedMesh/hkpCompressedMeshShapeBuilder.h>
#include <Common/SceneData/SceneDataToGeometryConverter/hkxSceneDataToGeometryConverter.h>
#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>

class hkRootLevelContainer;
class hkpExtendedMeshShape;

	/// A demo on how to use the compressed mesh shape.
class CompressedMeshDemo : public hkDefaultPhysicsDemo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		CompressedMeshDemo(hkDemoEnvironment* env);
		virtual ~CompressedMeshDemo();

	public:

		
		// The MOPP shape broken into chunks
		hkpShape* m_shape;

		// Keep track of time and use to move the casts around
		hkReal m_time;

		hkAabb m_bounds;
		int m_minIndex;

			/// The quantization error
		hkReal m_error;

			/// The compressed mesh shape builder
		hkpCompressedMeshShapeBuilder m_builder;

		hkArray< hkArray<hkpShapeKey> > m_keys;

		hkxSceneDataToGeometryConverter::GeometryInstances m_geometryInstances;

		struct GeometryInfo
		{
			int m_numInstances;
			
			int m_subpartID;
			
			hkMatrix4 m_firstTransform;
		};

		hkArray<GeometryInfo> m_geomInfo;

		hkOstream m_out;

		HK_ALIGN16 ( hkSemaphoreBusyWait m_semaphore );

		hkpRigidBody* m_castBody;

		hkpRigidBody* m_terrainBody;
		
		const hkpShape* m_terrainShape;

		hkVector4 m_geometryTranslation;

		hkpMeshMaterial materialTable[2];

		hkpCompressedMeshShape* m_compMesh;
		class hkResource* m_loadedData;

		hkGeometry m_geometry;

		hkAabb m_originalAabb;

		bool wireframe ;
		bool showWelded;
		bool showTJ;
		bool m_showChunks;
		//bool showMaterials;
		bool m_showAabb;
		
		bool m_showOriginalGeometry;

		bool m_showBreakdown;

	public:

		virtual Result stepDemo();

	protected:

		hkpShape* createMeshShape( hkDemoEnvironment* env );

		hkpShape* createCompressedMeshShape();
		
		hkpShape* createExtendedMeshShape();

		int testTriangleMapping( hkpShapeCollection* mesh, int& numValidKeys );

		void testRayCast();

		void testLinearCast();

		void randomRayCastScene();

		void addDisplayGeometry( hkGeometry geometry, const hkVector4& color, const hkVector4& translate );

		hkPseudoRandomGenerator m_random;
};



#endif // HK_CompressedMeshDemo_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
