/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#include <Common/Base/Algorithm/Sort/hkSort.h>

//
//	Test of a Minkowski Portal Refinement ray-casting algorithm against convex vertices shapes

#ifndef _HK_MPR_RAY_CAST_H_
#define _HK_MPR_RAY_CAST_H_

class hkMprRayCast : public hkReferencedObject
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		hkMprRayCast()
		:	hkReferencedObject()
		,	m_shape(HK_NULL)
		{}

		virtual ~hkMprRayCast()
		{}

	public:

		/// The ray-cast algorithm
		hkBool castRayMpr(const class hkpConvexVerticesShape* shape, const hkpShapeRayCastInput& input, hkpShapeRayCastOutput& results);

	protected:

		/// Computes 4 support vertices in the given direction
		void getSupportVertices(const hkVector4& vDir, hkVector4* vOut) const;

		/// Locates a vertex that forms a proper portal candidate. Assumes vertices vTetra[0], vTetra[1], vTetra[2] computed
		/// with vTetra[1] and vTetra[2] relative to vTetra[1]. Fills out vTetra[3] if possible
		hkBool findMinkowskiPortal(hkVector4* vTetra, const hkVector4& rayDir);

	protected:

		/// The shape we cast the ray against
		const class hkpConvexVerticesShape* m_shape;
};

#include <Demos/Physics/Api/Collide/RayCasting/ConvexVerticesRayCast/hkMprRayCast.inl>

#endif	// _HK_MPR_RAY_CAST_H_

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
