/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

// Tests the ray-casting algorithm for convex vertices shapes

#ifndef HK_CONVEX_VERTICES_RAYCAST_DEMO_H
#define HK_CONVEX_VERTICES_RAYCAST_DEMO_H

#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>
#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysicsDemo.h>

class ConvexVerticesRaycastDemo : public hkDefaultPhysicsDemo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		ConvexVerticesRaycastDemo(hkDemoEnvironment* env);
		virtual ~ConvexVerticesRaycastDemo();

		Result stepDemo(); 

		int handleKeys(char key);

	protected:
		
		/// Creates a random convex vertices shape
		class hkpConvexVerticesShape* createRandomShape();

		/// Clones the given convex vertices shape and removes the planes
		class hkpConvexVerticesShape* cloneShapeAndRemovePlanes(hkpConvexVerticesShape* cvSrc);

		/// Creates a random rigid body for the given shape
		class hkpRigidBody* createRandomRigidBody(class hkpConvexVerticesShape* shape);

		/// Clones the given rigid body and translates it on the Z axis by a constant amount
		class hkpRigidBody* cloneAndTranslateBody(class hkpRigidBody* body, hkpConvexVerticesShape* shape);

		/// Initializes a ray casting data structure
		int initRayCastCommand(class hkpRigidBody* body, const hkVector4& vWorldRayDir, const hkVector4& vWorldRayOffset, hkBool doFlip);

		/// Casts a ray towards the given rigid body
		void castRay(class hkpRigidBody* body, const hkVector4& vWorldRayDir, const hkVector4& vWorldRayOffset, hkBool doFlip, hkBool castAgainstPlanes);

		/// Casts all rays
		void castAllRays(const hkVector4& vX, const hkVector4& vY, const hkVector4& vZ);

		/// Processes the results of the ray-casts
		void processRayCastResults(int& falsePositives, int& falseNegatives, hkReal& posErrMax, hkReal& angErrMax);

		/// Renders the ray-cast test result
		void renderRayCastResult(const hkTransform& worldTM, int testIdx);

	protected:

		hkArray<class hkpConvexVerticesShape*> m_shapesWithPlanes;
		hkArray<class hkpConvexVerticesShape*> m_shapesWithoutPlanes;

		hkArray<class hkpRigidBody*> m_bodiesWithPlanes;
		hkArray<class hkpRigidBody*> m_bodiesWithoutPlanes;

		hkPseudoRandomGenerator m_rng;
		hkReal m_angleZ;
		hkReal m_angleXY;
		int m_currentIter;
		int m_startIter;

		hkArray<struct hkpShapeRayCastCommand> m_rayCastCommands;		// Array of sent ray-cast commands
		hkArray<const class hkpCollidable**> m_rayCastCollidables;		// Array of collidables, one for each ray-cast command
		hkArray<struct hkpWorldRayCastOutput> m_rayCastOutputs;		// Array of ray-cast outputs
		int m_currentRayCastCmdIndex;

		HK_ALIGN16 ( hkSemaphoreBusyWait	m_semaphore );

	protected:

		int m_numTotalFalsePositives;
		int m_numTotalFalseNegatives;
		hkReal m_maxLinError;
		hkReal m_maxAngError;

		// True if the MPR ray-cast algorithm is to be called. Only works in single-threaded mode.
		hkBool m_useMprRayCast;
};

#endif	// HK_CONVEX_VERTICES_RAYCAST_DEMO_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
