/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#include <Demos/demos.h>

#include <Demos/Physics/Api/Collide/RayCasting/AutoSplitJob/AutoSplitJobDemo.h>
#include <Demos/DemoCommon/Utilities/KdTree/KdTreeDemoUtils.h>

#include <Common/Internal/KdTree/hkKdTree.h>
#include <Physics/Dynamics/World/Util/KdTree/hkpKdTreeWorldManager.h>
#include <Physics/Dynamics/World/Util/AabbTree/hkpAabbTreeWorldManager.h>
#include <Common/Internal/KdTree/Build/hkKdTreeBuilder.h>
#include <Common/Internal/KdTree/Build/hkKdTreeBuildingUtils.h>
#include <Common/Internal/KdTree/QueryUtils/hkKdTreeUtils.h>

#include <Physics/Collide/Query/Collector/KdTreeCollector/hkpKdTreeCollidableRaycaster.h>
#include <Physics/Collide/Query/Collector/KdTreeCollector/hkpKdTreeWorldLinearCaster.h>
#include <Physics/Collide/Util/KdTree/Mediator/hkpCollidableMediator.h>

// Used for graphics and I/O
#include <Common/Base/Monitor/hkMonitorStream.h>
#include <Common/Base/Container/LocalArray/hkLocalArray.h>
#include <Common/Visualize/hkDebugDisplay.h>
#include <Demos/DemoCommon/Utilities/GameUtils/GameUtils.h>
#include <Demos/DemoCommon/DemoFramework/hkTextDisplay.h>

#include <Common/Visualize/hkDebugDisplay.h>
#include <Demos/DemoCommon/Utilities/KdTree/KdTreeDebugUtils.h>

// Serialization
#include <Common/Base/Container/LocalArray/hkLocalBuffer.h>

#include <Physics/Collide/Query/Collector/RayCollector/hkpClosestRayHitCollector.h>
#include <Physics/Collide/Query/CastUtil/hkpWorldRayCastInput.h>
#include <Physics/Collide/Query/CastUtil/hkpWorldRayCastOutput.h>

#include <Physics/Collide/BroadPhase/hkpBroadPhase.h>


#include <Physics/Collide/Query/Collector/PointCollector/hkpClosestCdPointCollector.h>
#include <Physics/Collide/Query/CastUtil/hkpLinearCastInput.h>
#include <Physics/Collide/Agent/hkpCollisionAgentConfig.h>
#include <Physics/Dynamics/Phantom/hkpSimpleShapePhantom.h>

#include <Graphics/Common/Font/hkgFont.h>

#include <Physics/Collide/Query/Multithreaded/RayCastQuery/Util/hkAabbTreeRaycastUtil.h>
#include <Physics/Collide/Query/Multithreaded/RayCastQuery/hkpRayCastQueryJobs.h>
#include <Physics/Collide/Query/Multithreaded/RayCastQuery/Cpu/hkpCpuKdTreeRayCastJob.h>
#include <Physics/Collide/Query/Multithreaded/RayCastQuery/hkpRayCastQueryJobQueueUtils.h>
#include <Physics/Collide/Query/Collector/AabbTreeCollector/hkpAabbTreeCollidableRaycaster.h>

#include <Physics/Collide/Query/Collector/PointCollector/hkpClosestCdPointCollector.h>
#include <Physics/Collide/Query/Collector/PointCollector/hkpFixedBufferCdPointCollector.h>
#include <Physics/Collide/Query/Multithreaded/CollisionQuery/hkpCollisionQueryJobQueueUtils.h>

#include <Demos/DemoCommon/Utilities/KdTree/KdTreeDemoUtils.h>

static int numBodies = 500;


enum Mode
{
	TEST_RAYCAST,
	TEST_LINEARCAST,
};


struct AutoSplitJobDemoVariant
{
	const char* m_name;
	const char* m_details;

	Mode m_mode;
};

static const AutoSplitJobDemoVariant g_variant[] =
{
	{"Raycast", "Raycast", TEST_RAYCAST},
	{"Linearcast", "Linearcast", TEST_LINEARCAST},
};


AutoSplitJobDemo::AutoSplitJobDemo(hkDemoEnvironment* env)
:hkDefaultPhysicsDemo( env ),
m_rand(123)
{
	{
		m_worldSizeX = 20.0f * 4.0f;
		m_worldSizeY = 30.0f*0.5f * 4.0f;
		m_worldSizeZ = m_worldSizeX;
	}

	// Setup the camera and graphics
	{
		// setup the camera
		hkVector4 from(0.0f, m_worldSizeY*0.5f, m_worldSizeZ*2.0f);
		hkVector4 to  (0.0f, 0.0f,  0.0f);
		hkVector4 up  (0.0f, 1.0f,  0.0f);
		setupDefaultCameras( env, from, to, up, 1.0f, 5000.0f );
	}


	{
		hkpWorldCinfo cinfo;
		cinfo.m_gravity = hkVector4::getZero();
		cinfo.m_broadPhaseWorldAabb.m_max.set( m_worldSizeX,  m_worldSizeY,  m_worldSizeZ);
		cinfo.m_broadPhaseWorldAabb.m_min.setNeg4(	cinfo.m_broadPhaseWorldAabb.m_max );
		cinfo.m_useKdTree = true;
		m_world = new hkpWorld(cinfo);
		m_world->lock();
	}


	{
		hkpAgentRegisterUtil::registerAllAgents(m_world->getCollisionDispatcher());
	}

	//
	// Add a lot of rigid bodies to the world
	//
	{
		hkAabb worldAabb; 
		worldAabb.m_max.set( m_worldSizeX,  m_worldSizeY,  m_worldSizeZ);
		worldAabb.m_max.mul4( 0.95f );
		worldAabb.m_min.setNeg4( worldAabb.m_max );	

		hkpMotion::MotionType motionType = hkpMotion::MOTION_BOX_INERTIA;
		KdTreeDemoUtils::createRandomBodies(m_world, worldAabb, numBodies, motionType, &m_rand, m_collidables);

		motionType = hkpMotion::MOTION_FIXED;
		KdTreeDemoUtils::createRandomBodies(m_world, worldAabb, numBodies, motionType, &m_rand, m_collidables);
	}

	hkArray<const hkpCollidable*> collidables;
	hkpAabbTreeWorldManager::gatherCollidablesFromWorld( collidables, m_world );
	m_treeManagerData.setSize( m_world->m_kdTreeManager->calcWorkingBufferSize( collidables.getSize() ) );
	m_world->m_kdTreeManager->setWorkingBuffer( m_treeManagerData.begin() );

	setupGraphics();

	m_world->unlock();

	hkpRayCastQueryJobQueueUtils::registerWithJobQueue(m_jobQueue);
	hkpCollisionQueryJobQueueUtils::registerWithJobQueue(m_jobQueue);

	if( g_variant[ m_variantId ].m_mode == TEST_LINEARCAST )
	{
		// register the default addCdPoint() function; you are free to register your own implementation here though
		m_world->lock();
		hkpFixedBufferCdPointCollector::registerDefaultAddCdPointFunction();
		m_world->unlock();
	}
}

AutoSplitJobDemo::~AutoSplitJobDemo()
{

}

void AutoSplitJobDemo::doRaycast()
{
	//	should be divided into 1000/64 jobs
	const int numRays = 1000;
	hkArray<hkpWorldRayCastInput> inputs( numRays );
	hkArray<hkpWorldRayCastOutput> results( numRays );
	hkArray<hkpWorldRayCastCommand> singleCommands( numRays );

	hkVector4 rmin, rmax;
	rmax.set( m_worldSizeX, m_worldSizeY, m_worldSizeZ );
	rmin.setNeg3( rmax );

	hkVector4 start;
	m_rand.getRandomVectorRange(rmin, rmax, start);


	for (int i=0; i < numRays; i++)
	{
		hkVector4 end;
		m_rand.getRandomVectorRange(rmin, rmax, end);

		inputs[i].m_from = start;
		inputs[i].m_to = end;
		inputs[i].m_filterInfo = 0;
	}

	for(int i=0; i<numRays; i++)
	{
		hkpWorldRayCastCommand& command = singleCommands[i];
		command.m_rayInput = inputs[i];
		command.m_rayInput.m_enableShapeCollectionFilter = false;
		command.m_rayInput.m_filterInfo = 0;
		results[i].reset();
		command.m_results = &results[i];
		command.m_resultsCapacity = 1;
		command.m_numResultsOut = 0;
		command.m_stopAfterFirstHit = false;
	}


	hkSemaphoreBusyWait* semaphore = new hkSemaphoreBusyWait(0, 1000); // must be allocated on heap, for SPU to work

	m_world->markForRead();
	m_world->castRayMt( singleCommands.begin(), singleCommands.getSize(), m_jobQueue, m_jobThreadPool, semaphore, 1000 );
	m_world->unmarkForRead();

	delete semaphore;

	for(int i=0; i<numRays; i++)
	{
		if( results[i].hasHit() )
		{
			const hkpCollidable* col = results[i].m_rootCollidable;
			hkAabb aabb;
			col->getShape()->getAabb( col->getTransform(), 0.0f, aabb );
			HK_DISPLAY_BOUNDING_BOX( aabb, hkColor::BLUE );

			hkVector4 hitpoint;
			hitpoint.setInterpolate4( singleCommands[i].m_rayInput.m_from, singleCommands[i].m_rayInput.m_to, results[i].m_hitFraction );
			HK_DISPLAY_LINE( start, hitpoint, hkColor::BLUE );
		}
		else
		{
			HK_DISPLAY_LINE( start, singleCommands[i].m_rayInput.m_to, hkColor::SLATEGRAY );
		}

	}
}

void AutoSplitJobDemo::doLinearcast()
{
	//	should be divided into 1000/64 jobs (1000/64)
	const int numCasts = 1000;
	hkArray<hkpWorldLinearCastCommand> commands( numCasts );
	hkArray<hkpRootCdPoint> results( numCasts );

	const hkpCollidable* castCollidable = m_collidables[ m_rand.getRand32() % m_collidables.getSize() ];

	hkVector4 start;
	start = hkpGetRigidBody(castCollidable)->getPosition();

	for (int i=0; i < numCasts; i++)
	{
		hkVector4 end;
		hkVector4 worldSize(m_worldSizeX, m_worldSizeY, m_worldSizeZ);
		m_rand.getRandomVector11(end);
		end.mul4(worldSize);

		hkpLinearCastInput input;
		input.m_to = end;
		input.m_maxExtraPenetration = HK_REAL_EPSILON;
		input.m_startPointTolerance = HK_REAL_EPSILON;

		hkpWorldLinearCastCommand& command = commands[i];
		command.m_input = input;
		command.m_collidable = castCollidable;
		command.m_results = &results[i];
		command.m_resultsCapacity = 1;
		command.m_numResultsOut = 0;
	}


	hkSemaphoreBusyWait* semaphore = new hkSemaphoreBusyWait(0, 1000); // must be allocated on heap, for SPU to work

	m_world->markForRead();
	m_world->linearCastMt( commands.begin(), commands.getSize(), m_jobQueue, m_jobThreadPool, semaphore, 1000 );
	m_world->unmarkForRead();

	delete semaphore;

	for(int i=0; i<numCasts; i++)
	{
		if( commands[i].m_numResultsOut == 1 )
		{

			hkVector4 hitpoint;
			hitpoint.setInterpolate4( start, commands[i].m_input.m_to, commands[i].m_results->m_contact.getDistance() );

			hkAabb aabbA, aabbB;
			results[i].m_rootCollidableA->getShape()->getAabb( results[i].m_rootCollidableA->getTransform(), 0.f, aabbA );
			results[i].m_rootCollidableB->getShape()->getAabb( results[i].m_rootCollidableB->getTransform(), 0.f, aabbB );


			HK_DISPLAY_BOUNDING_BOX( aabbA, hkColor::BLUE );
			HK_DISPLAY_BOUNDING_BOX( aabbB, hkColor::BLUE );

			HK_DISPLAY_LINE( start, hitpoint, hkColor::BLUE );

			//
// 			const hkpCollidable* col = results[i].m_rootCollidable;
// 			hkAabb aabb;
// 			col->getShape()->getAabb( col->getTransform(), 0.0f, aabb );
// 			HK_DISPLAY_BOUNDING_BOX( aabb, hkColor::BLUE );
// 
// 			hkVector4 hitpoint;
// 			hitpoint.setInterpolate4( singleCommands[i].m_rayInput.m_from, singleCommands[i].m_rayInput.m_to, results[i].m_hitFraction );
// 			HK_DISPLAY_LINE( start, hitpoint, hkColor::BLUE );
		}
		else
		{
			HK_DISPLAY_LINE( start, commands[i].m_input.m_to, hkColor::SLATEGRAY );
		}

	}
}

hkDemo::Result AutoSplitJobDemo::stepDemo()
{
	if (m_jobThreadPool->getNumThreads() == 0)
	{
		HK_WARN(0x34561f23, "This demo does not run with only one thread");
		return DEMO_STOP;
	}

	m_rand.setSeed( m_physicsStepCounter / 100 );
	hkDemo::Result res = hkDefaultPhysicsDemo::stepDemo();

	if( g_variant[m_variantId].m_mode == TEST_RAYCAST )
	{
		doRaycast();
	}
	else
	{
		doLinearcast();
	}

	return res;
}


static const char helpString[] = \
"This demo checks a raycast/linearcast job with a large casts are splited into several jobs(test pop function of these jobs).";

//HK_DECLARE_DEMO(KdTreeVsAabbTreeDemo, HK_DEMO_TYPE_PHYSICS, "KdTreeVsAabbTreeDemo", helpString);
HK_DECLARE_DEMO_VARIANT_USING_STRUCT( AutoSplitJobDemo, HK_DEMO_TYPE_PHYSICS, AutoSplitJobDemoVariant, g_variant, helpString );

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
