/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_CMP_KD_TREE_H
#define HK_CMP_KD_TREE_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysicsDemo.h>
#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>

class ComparisonToKdTreeDemo : public hkDefaultPhysicsDemo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);
		ComparisonToKdTreeDemo(hkDemoEnvironment* env);
		~ComparisonToKdTreeDemo();

		hkDemo::Result stepDemo();

		virtual void doRaycasts(hkReal& mTreeTime, hkReal& kdTreeTime, hkReal& worldTime);

		hkArray<const class hkpCollidable*> m_collidables;

	protected:

		void createRigidBodies();

		void createRandomBodies( hkpWorld* world, const hkAabb& worldAabb, int numBodies, hkReal bodyExtent, 
			hkpMotion::MotionType motionType, class hkPseudoRandomGenerator* rand, hkArray<const hkpCollidable*>& collidablesOut );

		void buildKdTree();

		hkpWorldCinfo m_cinfo;
		class hkKdTree* m_kdTree;

		//hkAabb	m_bounds;

		hkReal m_worldSizeX;
		hkReal m_worldSizeY;
		hkReal m_worldSizeZ;

		hkPseudoRandomGenerator m_rand;

		hkArray<hkUchar> m_treeManagerData;
};

#endif // HK_KD_RAYCASTING4_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
