/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_DETERMINISTIC_CALLBACKS_DEMO_H
#define HK_DETERMINISTIC_CALLBACKS_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysicsDemo.h>
#include <Common/Base/System/Io/Writer/Crc/hkCrcStreamWriter.h>

class TestListener;
class hkpContactListener;

class DeterministicCallbacksDemo : public hkDefaultPhysicsDemo
{
	public:
		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		DeterministicCallbacksDemo(hkDemoEnvironment* env);

		virtual ~DeterministicCallbacksDemo();

		virtual Result stepDemo(); 

	protected:

			// Build the landscape to drive on and add it to m_world.
		void buildLandscape();

		static void createRagdollGrid( hkpWorld* world, int x_size, int y_size, hkReal xStep, hkReal yStep, hkArray<hkpPhysicsSystem*>&	ragdollsOut, hkpContactListener* listener);
			
		void respawnRagdollsIfNecessary();
	public:
		hkArray<hkpPhysicsSystem*>	m_ragdolls;

		TestListener* m_testListener;

		hkCrc32StreamWriter m_hashStream;

		int m_frameCount;
};

#endif // HK_SLIDING_RAGDOLLS_DEMO_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
