/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef BROADPHASE_CULLING_DEMO_H
#define BROADPHASE_CULLING_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysicsDemo.h>

#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>

#include <Physics/Dynamics/Phantom/hkpSimpleShapePhantom.h>

//
// This demonstrate how to use hkpHybridBroadPhase for frustum culling.
//

class BroadphaseCullingDemo : public hkDefaultPhysicsDemo
{
	public:

		struct Variant
		{
			HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO,Variant);

			const char*	m_name;
			const char*	m_details;
			int			m_numRigidBodies;
			int			m_numUserObjects;
		};			

		enum SortMethod
		{
			SM_NONE,
			SM_APPROXIMATE,
			SM_EXACT
		};
		
		struct BackToFrontSort
		{
			HK_FORCE_INLINE hkBool32	operator()(const hkVector4& x, const hkVector4& y) const
			{
				return hkMath::isLess(x.getSimdAt(0), y.getSimdAt(0));
			}
		};

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		BroadphaseCullingDemo(hkDemoEnvironment* env);
		
		~BroadphaseCullingDemo();

		hkDemo::Result stepDemo();

		hkPseudoRandomGenerator			m_rand;
		hkArray<hkpSimpleShapePhantom*>	m_userObjects;
		hkQuaternion					m_orientations[2];
		hkReal							m_animTime;
		hkBool							m_cullFarPlane;
		hkBool							m_useVelocityForUserObjects;
		SortMethod						m_sorting;
};

#endif // BROADPHASE_CULLING_DEMO_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
