/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_WELD_CLOSEST_POINTS_H
#define HK_WELD_CLOSEST_POINTS_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysicsDemo.h>

extern const class hkClass ClosestPointsWithWeldingDemoOptionsClass;

struct GroundFreeBody
{
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,GroundFreeBody);
	hkpRigidBody* 					m_groundBody;
	hkpRigidBody* 					m_freeBody;
	hkVector4 						m_groundPosition;
	hkpWeldingUtility::WeldingType	m_weldingType;
};


class ClosestPointsWithWeldingDemo : public hkDefaultPhysicsDemo
{
public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

	ClosestPointsWithWeldingDemo( class hkDemoEnvironment* env );
	~ClosestPointsWithWeldingDemo( );

	struct Options
	{
		HK_DECLARE_REFLECTION();

		Options()
			:	m_showWireframe		( false ),
				m_weldClosestPoints ( true ),
				m_weldOpenEdges		( true ),
				m_maxHits			( 1 )
		{
		}

		hkBool			m_showWireframe;
		hkBool			m_weldClosestPoints;
		hkBool			m_weldOpenEdges;
		int				m_maxHits;
	};

	DEMO_OPTIONS_DECLARE(Options);

protected:
 
	hkReal			m_time;
	hkReal			m_speed;

	hkArray< GroundFreeBody > m_groundFreeBody;
	hkBool					 m_prevWeldOpenEdges;

	hkpRigidBody* createSphere( hkpMotion::MotionType motion = hkpMotion::MOTION_KEYFRAMED );
	hkpRigidBody* createBox( hkpMotion::MotionType motion = hkpMotion::MOTION_KEYFRAMED );
	hkpRigidBody* createCapsule( hkpMotion::MotionType motion = hkpMotion::MOTION_KEYFRAMED );
	
	void setupCamera(hkDemoEnvironment* env);
	void createWorld();
	void createWeldingInfo();
	Result stepDemo();

	hkpRigidBody* createGround( const hkVector4& position , const hkReal& size );
	hkpRigidBody* createMopp( const hkVector4* verts, hkUint16 numVerts, const hkUint16* indices, hkUint16 numIndices, hkVector4Parameter pos );
	
	void drawContactPoint(const hkContactPoint& contactPoint );	
};

#endif // HK_WELD_CLOSEST_POINTS_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
