/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_DEMO_RAYTRACER_UTIL_H
#define HK_DEMO_RAYTRACER_UTIL_H

#include <Graphics/Common/Texture/hkgTexture.h>
#include <Physics/Collide/Query/CastUtil/hkpWorldRayCastInput.h>
#include <Physics/Collide/Query/CastUtil/hkpWorldRayCastOutput.h>
#include <Physics/Collide/Shape/Query/hkpRayHitCollector.h>

// Enable or disable multi-threaded ray casts.
#define HK_RAYTRACE_ENABLE_MT	1

// Capacity when using collector.
#define HK_RAYTRACE_COLLECTOR_CAPACITY	8

#if HK_RAYTRACE_ENABLE_MT
#include <Physics/Collide/Query/Multithreaded/RayCastQuery/hkpRayCastQueryJobs.h>
#endif

// Use this macros to ray-trace the world with the current camera.
#define HK_RAYTRACE_WORLD(_resolution_ , _scale_ , _usecollector_)	{ \
														Raytracer rt; \
														rt.m_useCollector = _usecollector_; \
														rt.setup(m_env->m_window->getContext(),_resolution_); \
														rt.render(m_env->m_window->getCurrentViewport()->getCamera(),this); \
														rt.display(m_env->m_window, _scale_); \
													}

// Allow to raytrace the world when a key is pressed. to be used in a demo decl. header.
#define HK_RAYTRACE_WORLD_ON_KEY_PRESSED(_key_ , _resolution_ , _scale_ ) virtual void postRenderDisplayWorld(class hkgViewport* view) \
																			{ \
																				if(m_env->m_window->getKeyboard().getKeyState(_key_)) \
																				{ \
																					HK_RAYTRACE_WORLD(_resolution_, _scale_); \
																				}	\
																			}

//
// Simple raytracer used to debug and benchmark ray casting.
// Shade using the |hit normal|.
//
struct Raytracer
{
	struct CollectorResult
	{
		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, CollectorResult);

		HK_FORCE_INLINE hkpWorldRayCastOutput&	operator[](int i) { return m_outputs[i]; }
		HK_FORCE_INLINE const hkpWorldRayCastOutput&	operator[](int i) const { return m_outputs[i]; }

		hkpWorldRayCastOutput	m_outputs[HK_RAYTRACE_COLLECTOR_CAPACITY];
	};

	struct Collector : public hkpRayHitCollector
	{
		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, Collector);

		Collector()
		{
			m_numOutputs			=	0;
			m_earlyOutHitFraction	=	1.0f;
			for(int i=0;i<HK_RAYTRACE_COLLECTOR_CAPACITY;++i)
			{
				m_outputs[i].reset();
			}
		}
		void addRayHit( const hkpCdBody& cdBody, const hkpShapeRayCastCollectorOutput& hitInfo )
		{
			if(m_numOutputs < HK_RAYTRACE_COLLECTOR_CAPACITY)
			{
				hkpWorldRayCastOutput& out = m_outputs[m_numOutputs++];
				out.m_extraInfo			=	hitInfo.m_extraInfo;
				out.m_hitFraction		=	hitInfo.m_hitFraction;
				out.m_normal			=	hitInfo.m_normal;
				out.m_rootCollidable	=	cdBody.getRootCollidable();
			}						
		}
		
		CollectorResult	m_outputs;
		int				m_numOutputs;
	};

	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, Raytracer);
	
	Raytracer();
	~Raytracer();
	
	void	clear();
	void	setup(hkgDisplayContext* context, int resolution);
	void	render(const hkVector4& from, const hkVector4& to, const hkVector4& up, hkReal halfSize, class hkDefaultPhysicsDemo* demo);
	void	render(const hkgCamera* camera, class hkDefaultPhysicsDemo* demo);
	void	display(hkgWindow* window, hkReal scale=1.0f);
	
	int								m_res;
	hkgDisplayContext*				m_context;
	hkgTexture*						m_textureObject;
	hkUint8*						m_textureData;
	hkBool							m_useCollector;
	#if HK_RAYTRACE_ENABLE_MT
	hkArray<hkpWorldRayCastCommand>	m_commands;
	hkArray<hkpWorldRayCastOutput>	m_outputs;
	hkArray<CollectorResult>		m_collectorOutputs;
	#endif
};

#endif // HK_DEMO_RAYTRACER_UTIL_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
