/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#include <Demos/demos.h>
#include <Demos/DemoCommon/Utilities/Particles/Utilities/ContinuousEmissionUtil.h>

ContinuousEmissionUtil::ContinuousEmissionUtil()
	: m_emissionRate(0.f),
	  m_numParticlesRequested(0.f)
{
}

ContinuousEmissionUtil::ContinuousEmissionUtil(hkReal emissionRate)
	: m_emissionRate(emissionRate),
	  m_numParticlesRequested(0.f)
{
}

ContinuousEmissionUtil::~ContinuousEmissionUtil()
{
}

int ContinuousEmissionUtil::update(hkReal timestep)
{
	m_numParticlesRequested += m_emissionRate * timestep;
	int numParticlesToEmit = hkMath::hkFloorToInt(m_numParticlesRequested);
	m_numParticlesRequested -= hkReal(numParticlesToEmit);
	return numParticlesToEmit;
}

hkReal ContinuousEmissionUtil::getEmissionRate() const
{
	return m_emissionRate;
}

void ContinuousEmissionUtil::setEmissionRate(hkReal emissionRate)
{
	m_emissionRate = emissionRate;
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
