/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_DEMO2_TWEAKER_UTILS_H
#define HK_DEMO2_TWEAKER_UTILS_H

class hkClassMember;

// Displays and tweaks the values in a class
// Right now it supports the tweaking of ints, floats, bools and enums.
// Its generally used for game options.
// The member path leads to a specific part of the data .
// It is usally something like /myClassInstance/myPtrToClass/myEmbeddedClass/memberName
// Later we should extend this to understand specific types e.g.
// /myClassInstance/myPtrToClass/myEmbeddedClass/myArray/4
// /myClassInstance/myPtrToClass/myEmbeddedClass/myVector4/x
// /myClassInstance/myPtrToClass/myEmbeddedClass/myMatrix/1/2

class TweakerUtils
{
public:
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,TweakerUtils);

	enum FloatTweakType
	{
		ADDITIVE,
		MULTIPLICATIVE,
		NO_TWEAK
	};

	// Optional output structure (use displayDataAndRecordResults) which will record the full path and y location of all text output
	// This can be used to (for example) identify which value a mouse pointer is currently hovering over in screenspace.
	struct NameAndDisplayLocation
	{
	public:

		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO, NameAndDisplayLocation);

		extStringPtr m_name;
		float yLocation;
	};

	typedef hkBool (HK_CALL *HideMemberFunc)(const hkClassMember& m);

		// get the hkClass representing an instance, given the base class.
	static const hkClass* HK_CALL getInstanceClass( const hkClass* baseClass, const void* instance );

		// Traversal
	static hkStringPtr HK_CALL getNextSiblingPath(	const char* memberPath, const void* rootData, const class hkClass& rootKlass,
												HideMemberFunc hideMember=0 );

	static hkStringPtr HK_CALL getPrevSiblingPath(	const char* memberPath, const void* rootData, const class hkClass& rootKlass,
												HideMemberFunc hideMember=0 );

	static hkStringPtr HK_CALL getChildPath(	const char* memberPath, const void* rootData, const class hkClass& rootKlass,
												HideMemberFunc hideMember=0 );

	static hkStringPtr HK_CALL getParentPath(const char* memberPath, const void* rootData, const class hkClass& rootKlass);

		// Returns access to the class containing this member
	static hkStringPtr HK_CALL getClass(	const char* memberPath, const void* rootData, const class hkClass& rootKlass, 
										void*& data, const hkClass*& klass,
										HideMemberFunc hideMember=0 );

		// Manipulation
	static hkStringPtr HK_CALL tweakData(const char* memberPath, void* rootData, const hkClass& rootKlass, float delta = 0.0f, const hkReal threshold = 0.01f, FloatTweakType floatTweakType = MULTIPLICATIVE);

		// Manipulation
	static hkStringPtr HK_CALL clearData(const char* memberPath, void* rootData, const hkClass& rootKlass);

	static hkStringPtr HK_CALL setReal( const char* memberPath, void* rootData, const hkClass& rootKlass, float newValue );

		// Display
	static void HK_CALL displayData(	const char* memberPath, const void* rootData, const class hkClass& rootKlass, 
										class hkTextDisplay& disp, float x, float y,
										HideMemberFunc hideMember=0, hkUint32 selectedColor = 0xffffff00  );

		// Display and also record where each tweakable was displayed to
	static void HK_CALL displayDataAndRecordResults(	const char* memberPath, const void* rootData, const class hkClass& rootKlass, 
											class hkTextDisplay& disp, float x, float y,
											extArray<NameAndDisplayLocation>& nameAndDisplayLocationOut,
											HideMemberFunc hideMember=0, hkUint32 selectedColor = 0xffffff00  );

	static void HK_CALL displayMemberData(	const char* memberPath, const void* rootData, const class hkClass& rootKlass, 
											class hkTextDisplay& disp, float x, float& y, 
											const char* currentFullName, extArray<NameAndDisplayLocation>& nameAndDisplayLocationOut,
											HideMemberFunc hideMember=0, hkUint32 selectedColor = 0xffffff00 );

};

class DemoMouseTweaker
{
public: 
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,DemoMouseTweaker);

	struct TweakAlgorithmSpec
	{
		TweakAlgorithmSpec()
		{
			// Default tweaking
			hkReal delta = hkReal( hkMath::pow( 10.0f, 0.05f ) ) - 1.0f;
			m_positiveOffset = delta;
			m_negativeOffset = ( -delta / ( 1.0f + delta ) );
			m_threshold = 1e-5f;
			m_floatTweakType = TweakerUtils::MULTIPLICATIVE;
		}

		// Helper utils
		void setAdditive(hkReal delta);
		void setMultiplicative(int numMultsPerFactorOfTen, hkReal threshold = 1e-5f);

		hkReal m_positiveOffset;
		hkReal m_negativeOffset;
		hkReal m_threshold;
		TweakerUtils::FloatTweakType m_floatTweakType;
	};

	typedef void (HK_CALL *GetTweakAlgorithmSpecFunc)(const extStringBuf& memberWithPath, TweakAlgorithmSpec& tweakAlgorithmSpecInOut);

	struct MouseTweakerSettings
	{
		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,DemoMouseTweaker::MouseTweakerSettings);
		MouseTweakerSettings()
			: m_tweakee(HK_NULL),
				m_tweakName(" "),
				m_klass(HK_NULL),
				m_hideMembers(HK_NULL),
				m_getTweakAlgorithmSpecFunc(HK_NULL),
				m_demoEnvironment(HK_NULL)
		{

		}

		void* m_tweakee;
		extStringBuf m_tweakName;
		const hkClass* m_klass;
		TweakerUtils::HideMemberFunc m_hideMembers;
		GetTweakAlgorithmSpecFunc m_getTweakAlgorithmSpecFunc;
		hkDemoEnvironment* m_demoEnvironment;
	};

	
	static hkBool tweak(MouseTweakerSettings& settings);
};

#endif //HK_DEMO2_TWEAKER_UTILS_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
