/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#include <Demos/demos.h>
#include <Demos/DemoCommon/Utilities/GameUtils/Landscape/RoundTrack.h>

// We will need these shapes
#include <Physics/Collide/Shape/Compound/Tree/Mopp/hkpMoppBvTreeShape.h>
#include <Physics/Collide/Shape/Compound/Collection/CompressedMesh/hkpCompressedMeshShape.h>
#include <Physics/Collide/Shape/Compound/Collection/CompressedMesh/hkpCompressedMeshShapeBuilder.h>

#include <Physics/Collide/Shape/Compound/Tree/Mopp/hkpMoppUtility.h>
#include <Common/Base/Types/Geometry/hkGeometry.h>


RoundTrackDemo::RoundTrackDemo()
{
}

RoundTrackDemo::~RoundTrackDemo()
{
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

hkpMoppBvTreeShape* RoundTrackDemo::createMoppShape()
{
	//
	// Create the vertices (a "heightfield" of triangles)
	// As we do not need to keep this information, we use a temporary hkGeometry
	// to create a hkpCompressedMeshShape
	//
	hkGeometry geometry;
	geometry.m_vertices.setSize(NUM_VERTICES);
	geometry.m_triangles.setSize(NUM_TRIANGLES);
	{
		const float borderHeight = 5.0f;
		const hkReal radius = 500.0f;
		const hkReal width = 55.0f;
		const hkReal jumps = 0.15f;
		const hkReal bendsFrequency  = 10.0f;
		const hkReal bendsSize = 60.0f;
		{
			for(int i = 0; i < SIDEA; i++)
			{
				for (int j = 0; j < SIDEB; j++ )
				{

					float h = (hkMath::cos(0.2f*((hkReal)j + i)) + 0.5f * hkMath::sin( 0.2f*2.0f * i));
					h = h * h * h * h *h * h - 6;
					h *= jumps;

					//
					//	Now bend the track in a circle
					//
					hkReal angle = i / float(SIDEA) * 6.32f;
					float si = hkMath::sin( angle );
					float co = hkMath::cos( angle );

					int j2 = j-1; if ( j2<0 ) j2++;
					if ( j2 >= SIDEB - 2) j2--;

					float sj = j2 / float(SIDEB - 2);

					float bends = bendsSize * hkMath::sin( angle * bendsFrequency ) * hkMath::sin( angle * bendsFrequency * 0.34f ); 
					float x = si * (radius + sj * width + bends) + radius;
					float y = co * (radius + sj * width + bends);

					geometry.m_vertices[(i * SIDEB + j)].set(x, h, y);
				}
			}
		}
		//
		//	Add a border
		//
		{
			for(int i = 0; i < SIDEA; i++)
			{
				geometry.m_vertices[ (i * SIDEB + 0     ) * 3 ](1) = borderHeight;
				geometry.m_vertices[ (i * SIDEB + SIDEB-1) * 3 ](1) = borderHeight;
			}
		}
	}

	//
	// Create the triangles
	//
	{
		hkUint16 corner = 0;
		int index = 0;
		for(int i = 0; i < SIDEA - 1; i++)
		{
			for (int j = 0; j < SIDEB - 1; j++ )
			{
				geometry.m_triangles[index].set(corner, corner + 1, corner + SIDEB);
				geometry.m_triangles[index + 1].set(corner + 1, corner + SIDEB, corner + SIDEB + 1);
				index += 2;
				corner++; 
			}
			corner++; 
		}
	}

	hkpCompressedMeshShape* meshShape = hkpCompressedMeshShapeBuilder::createMeshFromGeometry(geometry, 0.001f, hkpCompressedMeshShape::MATERIAL_NONE);
	meshShape->setRadius(0.05f);

	hkpMoppCompilerInput mci;
	hkpMoppCode* code = hkpMoppUtility::buildCode( meshShape , mci);

	hkpMoppBvTreeShape* moppShape = new hkpMoppBvTreeShape(meshShape, code);
	code->removeReference();
	meshShape->removeReference();

	return moppShape;
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
