/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_DEMO2_GEOMETRY_LOADER_UTIL_H
#define HK_DEMO2_GEOMETRY_LOADER_UTIL_H

#include <Common/Base/Math/hkMath.h>

class hkResource;
struct hkGeometry;
class hkpSimpleMeshShape;
class hkRootLevelContainer;
class hkgDisplayWorld;
class hkgDisplayContext;
class hkgGeometry;

struct GeometryLoaderUtil
{
	public:
			// Load from a generic resource
		static void	HK_CALL load(hkResource* resource, hkGeometry& geometry);

			// Convert from a simple mesh shape to a geometry
		static void	HK_CALL load( hkpSimpleMeshShape* shape, hkGeometry& geometry);

			// Convert all found nodes in a root level container into a geometry
		static bool	HK_CALL load(hkRootLevelContainer* level,hkGeometry& geometry);

			// Utility function
		static void	HK_CALL merge(const hkGeometry& input, hkGeometry& output);

			// Utility function
		static void	HK_CALL scale(hkGeometry& geom,const hkVector4& s);

			// Scales the input geometry so that the longest extent is 'size' , returns the applied scale.
		static hkReal HK_CALL normalize(hkGeometry& geom, hkReal size, hkTransform* transformOut=HK_NULL );


			// Utility function
		static hkgGeometry*	HK_CALL createGeometry(const hkGeometry& mesh, hkgDisplayWorld* display, hkgDisplayContext* context, const hkVector4& color);

		static hkgDisplayObject* HK_CALL createDisplay(const hkArray<hkGeometry*>& meshes, hkgDisplayWorld* display, hkgDisplayContext* context);

		static hkgDisplayObject* HK_CALL createDisplay(const hkGeometry& mesh, hkgDisplayWorld* display, hkgDisplayContext* context, const hkVector4& color);
};

#endif // HK_DEMO2_GEOMETRY_LOADER_UTIL_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
