/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#include <Demos/demos.h>
#include <Demos/DemoCommon/Utilities/FileBrowser/FileBrowser.h>
#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>
#include <Graphics/Common/Font/hkgFont.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Serialize/Util/hkSerializeUtil.h>


hkBool32 HK_CALL hkFileFilter_isValidAssetFile( const char* path )
{
	if( hkString::endsWith(path, ".xml") || hkString::endsWith(path, ".hkx") || hkString::endsWith(path, ".hkt") )
	{
		return hkSerializeUtil::isLoadable( hkIstream(path).getStreamReader() );
	}

	return false;
}

hkBool32 HK_CALL hkDirectoryFilter_notCvs( const char* name )
{
	return hkString::strCmp(name, "CVS") != 0;
}

FileBrowser::FileBrowser(FileBrowser::FilterFunc fileFilter, FileBrowser::FilterFunc directoryFilter)
:	m_curDir("")
,	m_listing(&extAllocator::getInstance())
,	m_curIndex(0)
,   m_directoryFilter(directoryFilter)
,	m_fileFilter(fileFilter)
,	m_prevDir(" ") //anything which does not equal m_curDir
{
}


hkStringPtr FileBrowser::getFullPath( ) const
{
	if (m_curIndex < m_listing.getEntries().getSize())
	{
		hkStringBuf fullPath( m_curDir, "/", m_listing.getEntries()[m_curIndex].name );
		return fullPath.cString();
	}

	return "ERROR";
}

hkBool FileBrowser::parseAndDisplayDirectoryAndFiles(const hkDemoEnvironment* m_env, int startH, int startV, bool recurse)
{
	//m_env->m_textDisplay->outputText("Browse for file :", startH, startV, 0xffffffff);
	int textHeight = (5*(int)m_env->m_textDisplay->getFont()->getCharHeight()) / 4;
	int textWidth = (int)m_env->m_textDisplay->getFont()->getCharWidth();

	// get filtered listing
	if( m_prevDir != m_curDir )
	{
		m_listing.clear();
		m_toScan.clear();
		m_toScan.expandOne() = ""; // Force a rescan below
		hkFileSystem::DirectoryListing unfiltered(&extAllocator::getInstance());
		hkFileSystem::getInstance().listDirectory( m_curDir.cString(), unfiltered );
		const hkArrayBase<hkFileSystem::Entry>& ents = unfiltered.getEntries();
		for( int i = 0; i < ents.getSize(); ++i )
		{
			if( ents[i].isDir() && m_directoryFilter(ents[i].name) )
			{
				m_listing.addEntry( ents[i] );
			}
		}
		m_prevDir = m_curDir;
	}

	if( m_listing.getEntries().getSize() > 50 )
	{
		m_toScan.clear();
	}

	static int stepTick;
	const int SLOWDOWN = 1;

	if( m_toScan.getSize() && (++stepTick % SLOWDOWN) == 0 )
	{
		hkFileSystem::DirectoryListing listing(&extAllocator::getInstance());
		hkStringBuf cur(m_curDir, "/", m_toScan[0]);
		hkFileSystem::getInstance().listDirectory( cur.cString(), listing );
		const hkArrayBase<hkFileSystem::Entry>& ents = listing.getEntries();

		for( int i = 0; i < ents.getSize(); ++i )
		{
			hkStringBuf path( cur, ents[i].name );
			if( ents[i].isFile() && m_fileFilter( path.cString() ) )
			{
				hkStringBuf s(m_toScan[0], ents[i].name);
				m_listing.addFile( s );
			}
			else if( recurse && ents[i].isDir() && m_directoryFilter( ents[i].name ) )
			{
				hkStringBuf first(m_toScan[0], ents[i].name, "/");
				m_toScan.pushBack(first.cString());
			}
		}
		m_toScan.removeAtAndCopy(0);
	}

	// current entries
	const hkArrayBase<hkFileSystem::Entry>& entries = m_listing.getEntries();
	
	// show
	{
		{
			hkArray<const char*>::Temp parts;
			hkStringBuf curDir(m_curDir);
			curDir.split('/', parts);
			for( int i = 0; i < parts.getSize(); ++i )
			{
				m_env->m_textDisplay->outputText( parts[i], startH, startV, 0xdddddddd );
				startH += 2*textWidth;
				startV += textHeight;
			}
		}

		for( int i = 0; i < entries.getSize(); ++i )
		{
			const hkFileSystem::Entry& e = entries[i];
			hkStringBuf s; s.printf( e.isDir() ? "[ %s ]": "  %s", e.name);
			m_env->m_textDisplay->outputText( s, startH-textWidth, startV,  0xffffffff, 1, i!=m_curIndex ? -1 : 0 );
			startV += textHeight;
		}
		startH += textWidth;

		if( m_toScan.getSize() )
		{
			startV += textHeight;
			static int spinner; static const char spins[] = "/-\\|";
			hkStringBuf s; s.printf("%c %s", spins[spinner/SLOWDOWN], m_toScan[0].cString() );
			m_env->m_textDisplay->outputText( s, startH-textWidth, startV,  0xffffffff );
			spinner = (spinner+1) % (4*SLOWDOWN);
			startV += textHeight;
		}
	}

	// check pad status
	const hkgPad& pad = *m_env->m_gamePad;
	const hkgKeyboard& key = m_env->m_window->getKeyboard();
	
	if( pad.wasButtonPressed( HKG_PAD_DPAD_LEFT )  || key.wasKeyPressed(HKG_VKEY_BACK)) // go one level up
	{
		hkStringBuf p(m_curDir);
		p.pathDirname();
		m_curDir = p;
	}
	else if( entries.getSize() )
	{
		if( pad.wasButtonPressed( HKG_PAD_DPAD_DOWN ) ) // scroll down
		{
			m_curIndex = (m_curIndex+1) % entries.getSize();
		}
		else if( pad.wasButtonPressed( HKG_PAD_DPAD_UP ) ) // scroll up
		{
			m_curIndex = (m_curIndex-1+entries.getSize()) % entries.getSize();
		}
		else if( pad.wasButtonPressed( HKG_PAD_DPAD_RIGHT ) || pad.wasButtonPressed( HKG_PAD_BUTTON_0 ) )
		{
			if( entries[m_curIndex].isDir() ) // expand current directory
			{
				hkStringBuf c (m_curDir);
				if( m_curDir.getLength() ) c += "/";
				c += entries[m_curIndex].name;
				m_curDir = c;
				m_curIndex = 0;
			}
			else if( entries[m_curIndex].isFile() && 	pad.wasButtonPressed( HKG_PAD_BUTTON_0 ) ) // open file
			{
				
				return true;
			}
		}
	}
	return false;
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
