/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#include <Demos/demos.h>

#include <Demos/DemoCommon/Utilities/ExceptionHandler/hkExceptionHandler.h>
#include <Common/Base/System/StackTracer/hkStackTracer.h>

#include <imagehlp.h>

const char* hkGetExceptionString(DWORD exc)
{
#define EXC_CASE(EXC)	case EXCEPTION_##EXC : return "EXCEPTION_" #EXC
	switch (exc)
	{
		EXC_CASE(ACCESS_VIOLATION);
		EXC_CASE(DATATYPE_MISALIGNMENT);
		EXC_CASE(BREAKPOINT);
		EXC_CASE(SINGLE_STEP);
		EXC_CASE(ARRAY_BOUNDS_EXCEEDED);
		EXC_CASE(FLT_DENORMAL_OPERAND);
		EXC_CASE(FLT_DIVIDE_BY_ZERO);
		EXC_CASE(FLT_INEXACT_RESULT);
		EXC_CASE(FLT_INVALID_OPERATION);
		EXC_CASE(FLT_OVERFLOW);
		EXC_CASE(FLT_STACK_CHECK);
		EXC_CASE(FLT_UNDERFLOW);
		EXC_CASE(INT_DIVIDE_BY_ZERO);
		EXC_CASE(INT_OVERFLOW);
		EXC_CASE(PRIV_INSTRUCTION);
		EXC_CASE(IN_PAGE_ERROR);
		EXC_CASE(ILLEGAL_INSTRUCTION);
		EXC_CASE(NONCONTINUABLE_EXCEPTION);
		EXC_CASE(STACK_OVERFLOW);
		EXC_CASE(INVALID_DISPOSITION);
		EXC_CASE(GUARD_PAGE);
		EXC_CASE(INVALID_HANDLE);
	default:
		return "UNKNOWN";
	}
#undef EXC_CASE
}

// Lifted from hkStackTracerWin32.cxx
// We have to use StackWalk64 here, since we're interested in another thread's stack trace. 
int hkStackTracer_getStackTraceFromContext( CONTEXT* _context, hkUlong* trace, int maxtrace )
{
	CONTEXT& context = *_context;
	STACKFRAME64 stackFrame;
	::memset(&stackFrame, 0, sizeof(STACKFRAME64));

#if defined(HK_ARCH_X64)
	stackFrame.AddrPC.Offset = context.Rip;
	stackFrame.AddrFrame.Offset = context.Rsp;
	stackFrame.AddrStack.Offset = context.Rsp;
	DWORD machineType = IMAGE_FILE_MACHINE_AMD64;

#else
	stackFrame.AddrPC.Offset = context.Eip;
	stackFrame.AddrFrame.Offset = context.Ebp;
	stackFrame.AddrStack.Offset = context.Esp;
	DWORD machineType = IMAGE_FILE_MACHINE_I386;
#endif

	stackFrame.AddrPC.Mode = AddrModeFlat;
	stackFrame.AddrFrame.Mode = AddrModeFlat;
	stackFrame.AddrStack.Mode = AddrModeFlat;

	int i = 0;
	while (i < maxtrace)
	{
		BOOL result = StackWalk64(
			machineType,
			GetCurrentProcess(),
			GetCurrentThread(),
			&stackFrame,
			&context,
			HK_NULL,
			SymFunctionTableAccess64,
			SymGetModuleBase64,
			HK_NULL);
		if (!result || !stackFrame.AddrPC.Offset)
		{
			break;
		}
		else
		{
			// valid frame
			trace[i++] = static_cast<hkUlong>(stackFrame.AddrPC.Offset);
		}
	}
	return i;
}

static void HK_CALL stackTraceReportFunction(const char* str, void* f)
{
	hkprintf("ERROR: %s", str);
	fprintf((FILE*) f, "ERROR: %s", str);
}

LONG __stdcall hkWin32ExceptionFilter(EXCEPTION_POINTERS* exceptionPtrs)
{
#pragma comment(lib, "Dbghelp.lib")

	static volatile unsigned long s_inFilter = 0;

	// MSDN description: "Proceed with normal execution of UnhandledExceptionFilter. That means obeying the SetErrorMode  flags, or invoking the Application Error pop-up message box."
	LONG returnCode = EXCEPTION_CONTINUE_SEARCH;

	// Ignore multiple calls.
	if (s_inFilter != 0)
		return EXCEPTION_CONTINUE_EXECUTION;
	s_inFilter = 1;

	if (exceptionPtrs->ExceptionRecord->ExceptionCode == EXCEPTION_STACK_OVERFLOW)
	{
		// Cannot really do much in case of stack overflow, it'll probably bomb soon anyway.
		OutputDebugString("*** FATAL ERROR: EXCEPTION_STACK_OVERFLOW detected!");
	}
	else if (exceptionPtrs->ExceptionRecord->ExceptionCode == EXCEPTION_BREAKPOINT)
	{
		// The came from an HK_ASSERT. We already got the callstack, so don't spam any further.
		return EXCEPTION_CONTINUE_SEARCH;
	}

	static char* s_outputFilename = "exception.txt";
	FILE* f = fopen(s_outputFilename, "wt");

	
	fprintf(f, "ERROR: Exception: 0x%X - %s", exceptionPtrs->ExceptionRecord->ExceptionCode, hkGetExceptionString(exceptionPtrs->ExceptionRecord->ExceptionCode) );
	hkprintf(  "ERROR: Exception: 0x%X - %s", exceptionPtrs->ExceptionRecord->ExceptionCode, hkGetExceptionString(exceptionPtrs->ExceptionRecord->ExceptionCode) );
	fprintf(f, "ERROR:   at %04X:%p\n", exceptionPtrs->ContextRecord->SegCs, exceptionPtrs->ExceptionRecord->ExceptionAddress);
	hkprintf(  "ERROR:   at %04X:%p\n", exceptionPtrs->ContextRecord->SegCs, exceptionPtrs->ExceptionRecord->ExceptionAddress);

	if (exceptionPtrs->ExceptionRecord->ExceptionCode == EXCEPTION_ACCESS_VIOLATION)
	{
		const bool isWrite = exceptionPtrs->ExceptionRecord->ExceptionInformation[0] == 1;
		fprintf(f, "ERROR:  Attempt to %s 0x%08X\n", ( isWrite ? "write to" : "read from"), exceptionPtrs->ExceptionRecord->ExceptionInformation[1]);
		hkprintf(  "ERROR:  Attempt to %s 0x%08X\n", ( isWrite ? "write to" : "read from"), exceptionPtrs->ExceptionRecord->ExceptionInformation[1]);
	}

	fprintf(f, "\n");
	hkprintf(  "\n");

	hkUlong trace[20];
	int ntrace = hkStackTracer_getStackTraceFromContext(exceptionPtrs->ContextRecord, trace, sizeof(trace)/sizeof(trace[0]) );

	if( ntrace > 0 )
	{
		stackTraceReportFunction("Stack trace is:\n", f);
		hkStackTracer::getInstance().dumpStackTrace(trace, ntrace, &stackTraceReportFunction, f );
	}

	fclose(f);

	return returnCode;
}

void HK_CALL hkExceptionHandler::setExceptionHandlingEnabled( hkBool enabled )
{
	if (enabled)
	{
		SetUnhandledExceptionFilter(hkWin32ExceptionFilter);
	}
	else
	{
		SetUnhandledExceptionFilter(HK_NULL);
	}
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
