/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_TAPE_MEASURE_H
#define HK_TAPE_MEASURE_H


#include <Common/Base/hkBase.h>
#include <Common/Base/Math/Vector/hkVector4.h>

// Helps measure distance between two selected points in space.
// Currently only works for display lines - setPoint() reads the list of all display lines
// and find the closest to a ray first through the current mouse position.
// Once setPoint() has been called at least twice the last two points calculated above
// can be accessed by getPoints() and the distance trivial found.
//
// Sample use:
/*
    if ( m_env->m_gamePad->wasButtonPressed(HKG_PAD_BUTTON_3) )
	{
		m_tapeMeasure.setPoint( m_env );
	}

		// hit key '3' while hovering over desired lines

		// Display points and if we have at least two print length between them
	{
		hkArray<hkVector4> points;
		m_tapeMeasure.getPoints(points);
		for(int i = 0; i < points.getSize(); i++)
		{
			HK_DISPLAY_STAR( points[i], scale * 0.1f, hkColor::WHITE);
		}

		if( m_tapeMeasure.hasMeasure() )
		{
			const int h = m_env->m_window->getHeight();
			char buf[200];
			hkString::snprintf(buf, 200, "Length between tapemeasure points: %.6f", (hkReal) points[0].distanceTo3(points[1] ));
			m_env->m_textDisplay->outputText( buf, 20, h-140 );	
		}
	}
*/
//

class TapeMeasure
{
	public:
		TapeMeasure();
	
		// Returns false if setPoint() called less than 2 times, else true.
		hkBool hasMeasure()
		{
			return m_hasMeasure;
		}

		// Call to record the point (on some display line) under the mouse
		void setPoint(hkDemoEnvironment* env);

		// Returns 0, 1 or 2 points depending on how many times setPoint(0 has been called.
		void getPoints(hkArray<hkVector4>& pointsOut);

		// Another useful function. Gets length of largest line clipped inside current frustum
		// which gives an idea of approximate scale of scene being examined when zoomed in.
		// Returns -1 if no lines visible.
		static hkReal HK_CALL getLengthOfLargestVisibleLine(hkDemoEnvironment* env);


	private:	
		hkVector4	m_points[2];
		int			m_currentPoint;

		hkBool		m_hasMeasure;
};

#endif // HK_TAPE_MEASURE_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
