/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */


#include <Demos/demos.h>
#include <Demos/DemoCommon/Utilities/Drawing/TapeMeasure.h>
#include <Common/Visualize/hkDebugDisplay.h>

#include <Graphics/Bridge/DisplayHandler/hkgDisplayHandler.h>
#include <Common/Base/Algorithm/Collide/LineSegment/hkLineSegmentUtil.h>


TapeMeasure::TapeMeasure()
{
	m_hasMeasure = false;
	m_currentPoint = 0;
	m_points->setZero4();
	m_points->setZero4();
}

void TapeMeasure::setPoint( hkDemoEnvironment* env )
{
	// Construct ray to cast
	hkVector4 from, to;
	{
	
		hkgWindow* w = env->m_window;
		hkgViewport* v = w->getCurrentViewport();
		hkgCamera* c = v->getCamera();
		const hkgMouse& m = w->getMouse();

		int vx, vy;
		v->getLowerLeftCoord(vx, vy);

		const int x = m.getPosX() - vx;
		const int y = m.getPosY() - vy;


		hkReal nearVal = c->getNear();
		//	hkReal farVal = c->getFar();
		// We get numerical inaccuracy when near is very small - so change near temporarily
		c->setNear(0.1f);
		//	c->setFar(10.0f);
		c->orthogonalize();
		c->computeModelView();
		c->computeProjection();
		c->unProject( (x - vx), (y - vy), 0, v->getWidth(), v->getHeight(), &from(0) );
		c->unProject( (x - vx), (y - vy), 1, v->getWidth(), v->getHeight(), &to(0) );
		c->setNear(nearVal);
		//	c->setFar(farVal);
		c->orthogonalize();
		c->computeModelView();
		c->computeProjection();

		hkVector4 oldfrom = from;

		// But now from is not really where we want it to be, so move it back by 0.2 units
		hkVector4 dir;
		dir.setSub4( to, from );
		dir.normalize3();
		from.subMul4( 0.2f, dir );
	}


	// Get all display lines
	extArray<hkgDisplayHandler::DisplayLine>& displayLines = env->m_displayHandler->getDisplayLines();

	// Get all view frustum planes
	hkVector4 plane[6];
	for(int p = 0; p < 6; p++)
	{
		plane[p].load4( env->m_window->getCurrentViewport()->getCamera()->getFrustumPlane( p ));
	}

	// Compare (clipped) lines to raycast in 3D: find the closest distance between these 3D line segments
	hkVector4 intersection(0,0,0);
	hkReal minDistSqrd = HK_REAL_MAX;
	for(int i = 0; i < displayLines.getSize(); i++)
	{
		hkVector4 start = displayLines[i].m_start;
		hkVector4 end = displayLines[i].m_end;

		hkBool clippedAway = false;

		// Clip against view frustum planes
		for(int p = 0; p < 6; p++)
		{
			start(3) = -1.0f;
			end(3) = -1.0f;
			hkReal ds = -start.dot4( plane[p] );
			hkReal de = -end.dot4( plane[p] );

			if( (ds < 0) && (de < 0) )
			{
				clippedAway = true;
				break;
			}
		}

		if( !clippedAway )
		{
			hkLineSegmentUtil::ClosestLineSegLineSegResult result;
			hkVector4 d0;	d0.setSub4( end, start );
			hkVector4 d1;	d1.setSub4( to, from );	
			hkLineSegmentUtil::closestLineSegLineSeg(start, d0, from, d1, result);
			if( result.m_distanceSquared < minDistSqrd )
			{
				intersection = result.m_closestPointA;
				minDistSqrd = result.m_distanceSquared;
			}

		}
	}

	// We've found our 'best guess' display line hit. Record the closest display line point.
	if( minDistSqrd != HK_REAL_MAX )
	{
		m_points[m_currentPoint] = intersection;
		m_currentPoint++;
		if( m_currentPoint == 2 )
		{
			m_hasMeasure = true;
			m_currentPoint = 0;
		}
	}
}

void TapeMeasure::getPoints(hkArray<hkVector4>& pointsOut)
{
	// Get up to 2 points.
	if( !m_hasMeasure )
	{
		if( m_currentPoint == 1)
		{
			pointsOut.pushBack( m_points[0] );
			return;
		}
		return;
	}

	pointsOut.pushBack( m_points[0] );
	pointsOut.pushBack( m_points[1] );

}


hkReal HK_CALL TapeMeasure::getLengthOfLargestVisibleLine(hkDemoEnvironment* env)
{
	extArray<hkgDisplayHandler::DisplayLine>& displayLines = env->m_displayHandler->getDisplayLines();
	hkVector4 plane[6];
	for(int p = 0; p < 6; p++)
	{
		plane[p].load4( env->m_window->getCurrentViewport()->getCamera()->getFrustumPlane( p ));
	}

	hkReal maxlength = -1.0f;
	for(int i = 0; i < displayLines.getSize(); i++)
	{
		hkVector4 start = displayLines[i].m_start;
		hkVector4 end = displayLines[i].m_end;

		hkBool clippedAway = false;

		// clip against planes
		for(int p = 0; p < 6; p++)
		{
			start(3) = -1.0f;
			end(3) = -1.0f;
			hkReal ds = -start.dot4( plane[p] );
			hkReal de = -end.dot4( plane[p] );

			//	hkcout << "DS/DE: " << ds << " " << de << "\n";
			if( ds >= 0 && de >= 0 )
			{
				// Inside
				continue;
			}
			if( (ds < 0) && (de < 0) )
			{
				clippedAway = true;
			}
			else
			{
				// clip line
				hkVector4 edge;
				edge.setSub4(end, start);
				if( ds >= 0 && de < 0 )
				{
					hkReal projLength = plane[p].dot3( edge );
					hkReal ratio = -de / projLength;
					//		hkcout << projLength << " " << ratio << "\n";
					end.subMul4( ratio, edge );
				}
				else
				{
					hkReal projLength = -plane[p].dot3( edge );
					hkReal ratio = -ds / projLength;
					//		hkcout << projLength << " " << ratio << "\n";
					start.addMul4( ratio, edge );
				}
			}
		}

		if( !clippedAway )
		{
			hkReal length = start.distanceTo3( end );
			//	hkcout << length << " vis\n";
			if( length > maxlength )
			{
				maxlength = length;
			}
		}
	}

	return maxlength;
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
