/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

template<typename VEC> hkDrawAny& hkDrawAny::points( const VEC& p0 )
{
	int id = m_pts.getSize();
	hkDrawAnyConvert::toVector4( p0, m_pts.expandOne(), id );
	return *this;
}
template<typename VEC> hkDrawAny& hkDrawAny::points( const VEC& p0, const VEC& p1 )
{
	int id = m_pts.getSize();
	hkDrawAnyConvert::toVector4( p0, m_pts.expandOne(), id );
	hkDrawAnyConvert::toVector4( p1, m_pts.expandOne(), id+1 );
	return *this;
}
template<typename VEC> hkDrawAny& hkDrawAny::points( const VEC& p0, const VEC& p1, const VEC& p2 )
{
	int id = m_pts.getSize();
	hkDrawAnyConvert::toVector4( p0, m_pts.expandOne(), id );
	hkDrawAnyConvert::toVector4( p1, m_pts.expandOne(), id+1 );
	hkDrawAnyConvert::toVector4( p2, m_pts.expandOne(), id+2 );
	return *this;
}
template<typename VEC> hkDrawAny& hkDrawAny::points( const VEC& p0, const VEC& p1, const VEC& p2, const VEC& p3 )
{
	int id = m_pts.getSize();
	hkDrawAnyConvert::toVector4( p0, m_pts.expandOne(), id );
	hkDrawAnyConvert::toVector4( p1, m_pts.expandOne(), id+1 );
	hkDrawAnyConvert::toVector4( p2, m_pts.expandOne(), id+2 );
	hkDrawAnyConvert::toVector4( p3, m_pts.expandOne(), id+3 );
	return *this;
}
template<typename VEC> hkDrawAny& hkDrawAny::points( const VEC* src, int n, int stride )
{
	int id = m_pts.getSize();
	hkVector4* dst = m_pts.expandBy( n );
	for( int i = 0; i < n; ++i )
	{
		hkDrawAnyConvert::toVector4( *hkAddByteOffsetConst(src, i*stride), dst[i], id+i );
	}
	return *this;
}

template<typename VEC> hkDrawAny& hkDrawAny::indexed( const VEC* v, int i0 )
{
	hkDrawAnyConvert::toVector4( v[i0], m_pts.expandOne(), i0 );
	return *this;
}
template<typename VEC> hkDrawAny& hkDrawAny::indexed( const VEC* v, int i0, int i1 )
{
	hkDrawAnyConvert::toVector4( v[i0], m_pts.expandOne(), i0 );
	hkDrawAnyConvert::toVector4( v[i1], m_pts.expandOne(), i1 );
	return *this;
}
template<typename VEC> hkDrawAny& hkDrawAny::indexed( const VEC* v, int i0, int i1, int i2 )
{
	hkDrawAnyConvert::toVector4( v[i0], m_pts.expandOne(), i0 );
	hkDrawAnyConvert::toVector4( v[i1], m_pts.expandOne(), i1 );
	hkDrawAnyConvert::toVector4( v[i2], m_pts.expandOne(), i2 );
	return *this;
}
template<typename VEC> hkDrawAny& hkDrawAny::indexed( const VEC* v, int i0, int i1, int i2, int i3 )
{
	hkDrawAnyConvert::toVector4( v[i0], m_pts.expandOne(), i0 );
	hkDrawAnyConvert::toVector4( v[i1], m_pts.expandOne(), i1 );
	hkDrawAnyConvert::toVector4( v[i2], m_pts.expandOne(), i2 );
	hkDrawAnyConvert::toVector4( v[i3], m_pts.expandOne(), i3 );
	return *this;
}
template<typename VEC> hkDrawAny& hkDrawAny::indexed( const VEC* src, const int* indices, int n )
{
	hkVector4* dst = m_pts.expandBy( n );
	for( int i = 0; i < n; ++i )
	{
		hkDrawAnyConvert::toVector4( src[ indices[i] ], dst[i], indices[i] );
	}
	return *this;
}

template<typename VEC> hkDrawAny& hkDrawAny::offsets( const VEC& base, const VEC& off0 )
{
	hkVector4* dst = m_pts.expandBy( 2 );
	hkDrawAnyConvert::toVector4( base, dst[0], 0 );
	hkVector4 conv0;
	hkDrawAnyConvert::toVector4( off0, conv0, 1 );
	dst[1].setAdd4( dst[0], conv0 );
	dst[1].setW( conv0 );
	return *this;
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
