/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#include <Physics/Dynamics/Collide/ContactListener/hkpContactListener.h>
#include <Physics/Dynamics/Entity/hkpEntityListener.h>

/// This implementation of a hkpContactListener outputs reporting messages for each
/// contact point.
class ContactReporter : public hkpContactListener, public hkpEntityListener
{
	public:

		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, ContactReporter);

		//
		// Construction and Destruction
		//

			/// \param rigidBody the body whose contacts should be reported.
		ContactReporter( hkpRigidBody* rigidBody, int reportingLevel );

		virtual ~ContactReporter();

		//
		// Members from base class hkpContactListener which must be implemented:
		//

			/// Called after a contact point was added 
		virtual void contactPointCallback( const hkpContactPointEvent& event );

		//
		// Members from base class hkpContactListener which must be implemented:
		//

			/// Called when the entity is deleted. Important to use this event to remove ourselves as a listener.
		virtual void entityDeletedCallback( hkpEntity* entity );

			/// Called when the entity is removed from the hkpWorld
		virtual void entityRemovedCallback( hkpEntity* entity );

	public:
		// a small structure, which gets attached to each contact point
		struct  ContactPointInfo
		{
			HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO,  ContactPointInfo);
			int m_uniqueId;
		};

	protected:
	
		int m_uniqueIdCounter;

		// For clean up.

			/// Pointers to those infos currently allocated.
		hkArray<ContactPointInfo*> m_infos;
			/// For use only during a phase of contactPointCallbacks.
		hkArray<ContactPointInfo*> m_extantInfos;

	public:
		int m_reportingLevel;
};

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
