/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#include <Demos/demos.h>
#include <Demos/DemoCommon/Utilities/ContactReporter/ContactReporter.h>

#include <Common/Visualize/hkDebugDisplay.h>
#include <Common/Base/Algorithm/Sort/hkSort.h>

ContactReporter::ContactReporter( hkpRigidBody* rigidBody, int reportingLevel )
	: m_uniqueIdCounter( 0 ), m_reportingLevel( reportingLevel )
{
	rigidBody->addEntityListener( this );
	rigidBody->addContactListener( this );
}


ContactReporter::~ContactReporter()
{
	const int numContacts = m_infos.getSize();
	for ( int i = 0; i < numContacts; ++i )
	{
		delete m_infos[i];
	}
}

// Delete entries in oldInfos which do not occur in extantInfos.
// It assumes that the arrays are sorted.
static void deleteAbsentees( const hkArray<ContactReporter::ContactPointInfo*>& extantInfos, hkArray<ContactReporter::ContactPointInfo*>& oldInfos )
{
	int i = 0;
	int j = 0;
	const int infoSize = oldInfos.getSize();
	const int extantSize = extantInfos.getSize();

	while ( ( i < infoSize ) && ( j < extantSize ) )
	{
		if ( oldInfos[i] < extantInfos[j] )
		{
			delete oldInfos[i];
			++i;
		}
		else if ( oldInfos[i] == extantInfos[j] )
		{
			++i;
			++j;
		}
		else
		{
			++j;
		}
	}
	while ( i < infoSize )
	{
		delete oldInfos[i];
		++i;
	}
}

void ContactReporter::contactPointCallback( const hkpContactPointEvent& event )
{
	if ( m_reportingLevel >= hkDemoEnvironment::REPORT_INFO )
	{
		ContactPointInfo* info;
		if ( event.m_contactPointProperties->m_flags & hkContactPointMaterial::CONTACT_IS_NEW )
		{
			hkprintf( "New contact point" );
			info = new ContactPointInfo;
			info->m_uniqueId = m_uniqueIdCounter++;
			event.m_contactPointProperties->setUserData( reinterpret_cast<hkUlong>(info) );
		}
		else
		{
			hkprintf( "Contact point" );
			info = reinterpret_cast<ContactPointInfo*>( event.m_contactPointProperties->getUserData() );
		}
		m_extantInfos.pushBack( info );

		hkprintf( " userId=%i", info->m_uniqueId );
		
		switch( event.m_type )
		{
			case hkpContactPointEvent::TYPE_TOI:
				hkprintf( " type=TOI" );
				break;
			case hkpContactPointEvent::TYPE_MANIFOLD:
				hkprintf( " type=MANIFOLD" );
				break;
			default:
			case hkpContactPointEvent::TYPE_EXPAND_MANIFOLD:
				hkprintf( " type=EXPAND_MANIFOLD" );
				break;
		}

		hkprintf( "\n" );
	}
	// Clean up any contactPointInfos for non-extant contact points.
	if ( event.m_lastCallbackForFullManifold )
	{
		hkSort( m_extantInfos.begin(), m_extantInfos.getSize() );
		deleteAbsentees( m_extantInfos, m_infos );
		m_infos.clearAndDeallocate();
		m_infos.swap( m_extantInfos );
	}
}


void ContactReporter::entityDeletedCallback( hkpEntity* entity )
{
	// Remove the collision event listener
	entity->removeContactListener( this ); 
	entity->removeEntityListener( this );

	// Now that we're removed from our entity, we can remove ourselves, too.
	delete this;
}


void ContactReporter::entityRemovedCallback( hkpEntity* entity )
{
	// Do nothing (we'll remove the collision event listener only when the entity is deleted)
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
