/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#include <Demos/demos.h>
#include <Demos/DemoCommon/Utilities/ContactPainter/ContactPainter.h>

#include <Common/Visualize/hkDebugDisplay.h>

ContactPainter::ContactPainter( hkpRigidBody* rigidBody, hkReal scale )
	: m_scale( scale )
{
	rigidBody->addEntityListener( this );
	rigidBody->addContactListener( this );
}


ContactPainter::~ContactPainter()
{
}


void ContactPainter::contactPointCallback( const hkpContactPointEvent& event )
{
	const hkVector4& start = event.m_contactPoint->getPosition();
	hkVector4 normal = event.m_contactPoint->getNormal();

	if ( event.m_contactPointProperties->m_flags & hkContactPointMaterial::CONTACT_IS_NEW )
	{
		// draw the contact point as a little red star
		for ( int i = 0; i < 20; i++ )
		{
			hkVector4 dir( hkMath::sin( i * 1.0f ), hkMath::cos( i * 1.0f ), hkMath::sin(i * 5.0f ) );
			dir.setMul4( 0.3f * m_scale, dir);

			hkVector4 end;
			end.setAdd4(start, dir);
			HK_DISPLAY_LINE(start, end, hkColor::RED);
		}
	}

	normal.setMul4(5.0f, normal);

	// For ease of display only, we'll always draw the normal "up" (it points from entity 'B'
	// to entity 'A', but the order of A,B is arbitrary) so that we can see it. Thus, if it's 
	// pointing "down", flip its direction (and scale), only for display.
	if( normal(1) < 0.0f )
	{
		normal.setMul4( -5.0f * m_scale, normal );
	}
	else
	{
		normal.setMul4( 5.0f * m_scale, normal );
	}

	hkVector4 end;
	end.setAdd4( start, normal );

	HK_DISPLAY_LINE( start, end, hkColor::WHITE );
}


void ContactPainter::entityDeletedCallback( hkpEntity* entity )
{
	// Remove the collision event listener
	entity->removeContactListener( this ); 
	entity->removeEntityListener( this );

	// Now that we're removed from our entity, we can remove ourselves, too.
	delete this;
}


void ContactPainter::entityRemovedCallback( hkpEntity* entity )
{
	// Do nothing (we'll remove the collision event listener only when the entity is deleted)
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
