/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_ANIMATED_DEMO_CHARACTER_H
#define HK_ANIMATED_DEMO_CHARACTER_H

#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/SimpleDemoCharacter/SimpleDemoCharacter.h>

// Vertex Deformation
#include <Animation/Animation/Deform/Skinning/hkaMeshBinding.h>

// State Machine
#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/AnimatedDemoCharacter/StateMachine/SimpleBipedStateMachine.h>
#include <Demos/DemoCommon/Utilities/Character/DemoCharacter/AnimatedDemoCharacter/StateMachine/States/SimpleBipedStates.h>

class SimpleBipedStateManager;
class AnimationEventQueue;
class SimpleBipedStateContext;
class hkaSkeleton;
class hkaAnimationBinding;
class hkaAnimatedSkeleton;
class hkLoader;

struct AnimatedDemoCharacterAnimationSet  
{
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,AnimatedDemoCharacterAnimationSet);
	hkaSkeleton*			m_skeleton;
	hkaAnimationBinding*	m_idle;
	hkaAnimationBinding*	m_walk;
	hkaAnimationBinding*	m_run;
	hkaAnimationBinding*	m_jump;
	hkaAnimationBinding*	m_inAir;
	hkaAnimationBinding*	m_land;
	hkaAnimationBinding*	m_dive;

	hkReal m_walkRunSyncOffset;	// Sync offset for walk to run 

	hkVector4 m_animFwdLocal;
	hkVector4 m_animUpLocal;

	// Store a pointer to the rig container, so that other classes can get at ragdolls, mappers, etc.
	class hkRootLevelContainer* m_rigContainer;

	HK_FORCE_INLINE AnimatedDemoCharacterAnimationSet()
		:	m_skeleton(HK_NULL),
			m_idle(HK_NULL),
			m_walk(HK_NULL),
			m_run(HK_NULL),
			m_jump(HK_NULL),
			m_inAir(HK_NULL),
			m_land(HK_NULL),
			m_dive(HK_NULL),
			m_rigContainer(HK_NULL)
	{
	}
};

struct AnimatedDemoCharacterDisplay
{
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,AnimatedDemoCharacterDisplay);
	bool m_hardwareSkinning;
	
	hkArray< hkRefPtr<hkaMeshBinding> >	m_skinBindings; // a

	hkArray<class hkgDisplayObject*> m_skinDisplay; // assert on   size == m_numSkinBindings

	HK_FORCE_INLINE AnimatedDemoCharacterDisplay()
		: m_hardwareSkinning(false) {}
};

class AnimatedCharacterFactory : public CharacterFactory
{
	public:
		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);

		AnimatedCharacterFactory( CharacterType defaultType = CHARACTER_TYPE_FIREFIGHTER );
		~AnimatedCharacterFactory();

		virtual DemoCharacter* createCharacterUsingProxy(	CharacterProxy* proxy,
															const hkVector4& gravity,
															hkDemoEnvironment* env,
															CharacterType characterType = MAX_CHARACTER_TYPE );

		void loadBasicAnimations( CharacterType type );

	protected:

		hkLoader* m_loader;

		CharacterType m_type;
		
		AnimatedDemoCharacterAnimationSet m_animSet[MAX_CHARACTER_TYPE];
		AnimatedDemoCharacterDisplay m_display[MAX_CHARACTER_TYPE];
};


struct AnimatedDemoCharacterCinfo : public DemoCharacterCinfo
{
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,AnimatedDemoCharacterCinfo);
	hkVector4		m_gravity;

	// For animation
	hkVector4		m_animationForwardLocal;
	hkVector4		m_animationUpLocal;

	struct AnimatedDemoCharacterAnimationSet* m_animationSet;
};

class AnimatedDemoCharacter : public DemoCharacter
{
	public:
		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
			// Create a default first person character
		AnimatedDemoCharacter( AnimatedDemoCharacterCinfo& cinfo );

		~AnimatedDemoCharacter();

		// Update the character position
		//   All of the update is multithreading-friendly, so the init and finish stages don't need to do anything
		virtual void initUpdateSt( hkReal timestep, hkpWorld* world, const struct CharacterStepInput& input, struct CharacterActionInfo* actionInfo = HK_NULL ) {}
		virtual void updateMt( hkReal timestep, hkpWorld* world, const struct CharacterStepInput& input, struct CharacterActionInfo* actionInfo = HK_NULL );
		virtual void finishUpdateSt( hkReal timestep, hkpWorld* world, const struct CharacterStepInput& input, struct CharacterActionInfo* actionInfo = HK_NULL ) {}

		virtual void display( hkReal timestep, hkDemoEnvironment* env );

		void cleanupGraphics( hkDemoEnvironment* env ) {} 

		virtual hkReal getMaxVelocity() const;

			// Sample animations
		void updateAnimation( hkReal timestep, hkQsTransform* poseLS );

			// Do skinning etc.
		void updateDisplay( int numBones, const hkQsTransform* poseMS, hkDemoEnvironment* env  );

		// Get the forward direction in local space
		const hkVector4& getAnimationForwardLocal();

		// The the up direction in local space
		const hkVector4& getAnimationUpLocal();

		const hkaSkeleton* getSkeleton() const;

		void loadSkin( hkLoader* loader, hkDemoEnvironment* env, AnimatedCharacterFactory::CharacterType type, AnimatedDemoCharacterDisplay& displayInfoCache );
		void cloneSkin( hkDemoEnvironment* env, AnimatedDemoCharacterDisplay& displayInfo );

	public:

		// Utility update functions
		void updatePosition( hkReal timestep, const CharacterStepInput& input, bool& isSupportedOut );


	protected:

			// Creates animated skeletons and stats machine etc.
		virtual void initAnimation( const AnimatedDemoCharacterAnimationSet* set );


			// Renders the skin around the given pose
		void doSkinning ( int numBones, const hkQsTransform* poseMS, const hkTransform& worldFromModel, hkDemoEnvironment* env );
		
	public:

		hkVector4					m_gravity;

			// Animation
		hkVector4					m_animationForwardLocal;
		hkVector4					m_animationUpLocal;
		SimpleBipedStateManager*	m_stateManager;
		AnimationEventQueue*		m_animationMachine;
		SimpleBipedStateContext*	m_animationStateMachine;
		hkaAnimatedSkeleton*		m_animatedSkeleton;

			// Cached
		hkRotation				m_characterFromAnimation;

			// Used to filter the "supported" signal
		hkReal					m_timeUnsupported;

			// For skinning
		hkBool					m_skinsLoaded;
		hkBool					m_hardwareSkinning;

		hkArray< hkRefPtr<hkaMeshBinding> > m_skinBindings;
		hkArray<class hkgDisplayObject*> m_skins;

		hkBool					m_bUseHardwareSkinning;
		hkBool					m_bUseWorldHardwareSkinning;

			// For locomotion
		hkReal	m_walkVelocity;
		hkReal	m_runVelocity;

			// For stop state
		hkReal		m_idleVelocity;
		hkReal		m_idleVelocityInterval;

		hkReal		m_idleCumulativeAngle;
		hkVector4	m_idleCumulativePosition;			

};

#endif // HK_ANIMATED_DEMO_CHARACTER_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
