/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef ANIMATION_UTILS_H
#define ANIMATION_UTILS_H

#include <Animation/Animation/Deform/Skinning/Fpu/hkaFPUSkinningDeformer.h>
#include <Animation/Animation/Deform/Skinning/Simd/hkaSimdSkinningDeformer.h>
#include <Animation/Animation/Deform/hkaVertexDeformerInput.h>


class hkaPose;
class hkaSkeleton;
class hkaDefaultAnimationControl;
class hkLoader;
class hkaAnimationBinding;
class hkaMeshBinding;
class hkgSceneDataConverter;
class hkaBoneAttachment;

class AnimationUtils
{
	public:
		/// Skinning utility. N.B. 4th row of worldTransform is not used (assumed == (0,0,0,1))
		static void HK_CALL skinMesh(const class hkxMesh& inputMesh, const hkTransform& worldTransform, const class hkTransform* worldCompositeMatrices, const hkgSceneDataConverter& graphicsScene);
		static void HK_CALL skinMesh(const class hkxMesh& inputMesh, class hkgDisplayObject* dObj, const hkTransform& worldTransform, const class hkTransform* worldCompositeMatrices, const hkgSceneDataConverter& graphicsScene);
		static void HK_CALL skinMesh(const hkaPose& pose, const hkArray<hkRefPtr<hkaMeshBinding> >& skinBinding, const hkTransform& worldTransform, const hkgSceneDataConverter& graphicsScene);
		static void HK_CALL skinMesh(hkQsTransform* poseLocal, const hkArray<hkRefPtr<hkaMeshBinding> >& skinBinding, const hkQsTransform& worldTransform, const hkgSceneDataConverter& graphicsScene);
		static void HK_CALL skinMesh(hkQsTransform* poseLocal, const hkArray<hkRefPtr<hkaMeshBinding> >& skinBinding, const hkArray< hkRefPtr<hkgDisplayObject> >& displayObjects, const hkQsTransform& worldTransform, const hkgSceneDataConverter& graphicsScene);
		
		/// Draw utils
		static void HK_CALL drawPose( const hkaPose& pose, const hkQsTransform& worldFromModel, int color=0x7fffffff, hkReal size = 0.25f, hkBool showRootTranslation = false );

		static void HK_CALL drawAttachments( const class hkDemoEnvironment* env, const hkQsTransform* poseInWorld, const hkArray< hkRefPtr< hkaBoneAttachment > >& boneAttachments, const hkArray< class hkgDisplayObject* >& attachmentObjects );

		static void HK_CALL createGraphicsMeshesForAttachments( const hkDemoEnvironment* env, const hkArray< hkRefPtr< hkaBoneAttachment > >& boneAttachments, hkArray< class hkgDisplayObject* >& attachmentObjectsOut );

		static void HK_CALL drawVertices(const class hkxVertexBuffer& vertexBuffer, int color);

		static void HK_CALL drawWeightedVertices(const class hkxVertexBuffer& vertexBuffer, int boneHighlight = 0 );

		static hkBool HK_CALL usingInt8BoneIndices(const class hkxVertexBuffer* iBuffer);

		template <class FPUSkinBinding>
		static void HK_CALL setupFloatBinding( const hkaVertexDeformerInput* input, const class hkxVertexBuffer* iBuffer, class hkgVertexSet* oBuffer, FPUSkinBinding* binding);
				
		template <class SimdSkinBinding>
		static void HK_CALL setupSimdBinding( const hkaVertexDeformerInput* input, const class hkxVertexBuffer* iBuffer, class hkgVertexSet* oBuffer, SimdSkinBinding* binding);
		
		
		static hkaDefaultAnimationControl* HK_CALL loadControl( hkLoader& loader, const char* assetName );
		static hkaAnimationBinding* HK_CALL loadAnimation( hkLoader& loader, const char* assetName );
};


#endif // ANIMATION_UTILS_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
