/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#include <Demos/demos.h>
#include <Common/Base/Config/hkConfigVersion.h>
#include <Demos/DemoCommon/DemoFramework/hkTestDemo.h>

#define HK_TEST_DECLARE(func) extern const hkTestEntry register##func;
#include HK_UNIT_TEST_LIST
#undef HK_TEST_DECLARE

const hkTestEntry* hkUnitTestDatabase[] = 
{
	#define HK_TEST_DECLARE(func) &register## func,
	#include HK_UNIT_TEST_LIST
	#undef HK_TEST_DECLARE
	HK_NULL
};


static hkDemo* HK_CALL hkCreateUnitTestDemo( hkDemoEnvironment* env )
{
	return new TestDemo(env);
}
static hkDemo* HK_CALL hkCreateUnitTestDemoWithAutoRecovery( hkDemoEnvironment* env )
{
	return new TestDemo(env, true);
}

void HK_CALL registerUnitTests( extArray<extStringPtr>& extraNames, extArray<hkDemoEntryRegister*>& allocedDemos)
{
	// extraDemos keeps track of all extra items which are registered at the end.
	extArray<hkDemoEntryRegister*> extraDemos;

	//
	// Go through the test database and add new demos for each test
	// These ones are dynamically allocated
	//
	{
		for( int ti = 0; hkUnitTestDatabase[ti] != HK_NULL; ti += 1 )
		{
			const hkTestEntry* testEntry = hkUnitTestDatabase[ti];

			extStringBuf path(testEntry->m_path);
			path.replace('\\','/');
			path.replace("./UnitTest/","");
            path += "/";

			extraNames.pushBack(path.cString());

			hkDemoEntryRegister* registeredDemo = new hkDemoEntryRegister(
				hkCreateUnitTestDemo, HK_DEMO_TYPE_TEST, extraNames.back(), -1, HK_NULL, "", "", true);
			extraDemos.pushBack(registeredDemo);
			allocedDemos.pushBack(registeredDemo);
		}
	}
	//
	//	Extract the categories from each test game and make them a new game as well
	//
	{
		if( extraNames.getSize() != 0 )
		{
			// Push back each category as a separate game too
			extArray<const char*> categories;
			for( int ti = 0; hkUnitTestDatabase[ti] != HK_NULL; ti += 1 )
			{
				const hkTestEntry* testEntry = hkUnitTestDatabase[ti];
				if (categories.indexOf(testEntry->m_category) == -1)
				{
					categories.pushBack(testEntry->m_category);
				}
			}


			extStringBuf prefix = "./UnitTest/";

			for (int i=0; i < categories.getSize(); i++)
			{
				extStringPtr& l_path = extraNames.expandOne();
				l_path.printf("%s%s/", prefix.cString(), categories[i] );

				hkDemoEntryRegister* registeredDemo = new hkDemoEntryRegister( 
					hkCreateUnitTestDemoWithAutoRecovery, HK_DEMO_TYPE_TEST, l_path, -1, HK_NULL, "Run Test", "");
				extraDemos.pushBack(registeredDemo);
				allocedDemos.pushBack( registeredDemo );
			}

			{
				// Special case 'All tests'
				extStringPtr& l_path = extraNames.expandOne();
				l_path.printf("%sAll Tests/", prefix.cString() );
				hkDemoEntryRegister* registeredDemo = new hkDemoEntryRegister(
					hkCreateUnitTestDemoWithAutoRecovery, HK_DEMO_TYPE_TEST, l_path, -1, HK_NULL, "Run All Unit Tests", "");
				extraDemos.pushBack(registeredDemo);
				allocedDemos.pushBack( registeredDemo );
			}
		}
	}
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
