/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#include <Demos/demos.h>
#include <Demos/DemoCommon/DemoFramework/hkTestDemo.h>
#include <Demos/DemoCommon/DemoFramework/hkDemoConsole.h>
#include <Demos/DemoCommon/DemoFramework/hkDoubleConvCheck.h>
#include <Demos/DemoCommon/DemoFramework/hkDemoFramework.h>

#include <Graphics/Common/Input/Pad/hkgPad.h>
#include <Graphics/Common/Window/hkgWindow.h>

#include <Common/Base/System/Io/OStream/hkOStream.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Common/Base/System/Stopwatch/hkStopwatch.h>
#include <Common/Base/System/Error/hkDefaultError.h>
#include <Common/Base/UnitTest/hkUnitTest.h>


#include <Common/Base/Fwd/hkstandardheader.h>
#include HK_STANDARD_HEADER(stdlib)
#include HK_STANDARD_HEADER(string)
#include HK_STANDARD_HEADER(setjmp)

	// C4611 interaction between '_setjmp' and C++ object destruction is non-portable
	// yes we know.
#	pragma warning(disable: 4611)

using namespace std;

/////////////////////////////

class TestDemo;
static jmp_buf s_jumpBuffer;
static TestDemo* s_testGame;
static extStringBuf* s_errorText = HK_NULL;


static const char* nthLine(const char* s, int n)
{
	const char* p = s;
	while(*p && n)
	{
		n -= *p++ == '\n';
	}
	return p;
}


hkBool HK_CALL hkTestReport(hkBool32 cond, const char* desc, const char* file, int line)
{
	if(cond == 0)
	{

        s_testGame->failCurrentTest(TestDemo::FAIL_NORMAL);
		
        //.\Utilities\Menu\MenuDemo.cpp(28) : fatal error C1189: #error :  test
		hkStringBuf err;
		err.printf("%s (%i) : error : %s\n", file, line, desc);
		if (s_errorText)
		{
			*s_errorText += err;
		}
		else
		{
			hkprintf("%s", err.cString() );
		}
	}
	return cond != false;
}

extern hkTestReportFunctionType hkTestReportFunction;

TestDemo::TestDemo(hkDemoEnvironment* env, hkBool autoRecoverFromErrors, hkTestEntry* overrideTest)
	:	hkDefaultDemo(env),
		m_autoRecoverFromErrors(autoRecoverFromErrors),
		m_firstLineShown(0),
		m_numPasses(0),
		m_numFails(0)
{
	// Init test function
	hkTestReportFunction = &hkTestReport;
	
	m_error.m_owner = this;

	for( int ti = 0; hkUnitTestDatabase[ti] != HK_NULL; ti += 1 )
	{
		const hkTestEntry* test = hkUnitTestDatabase[ti];
		hkStringBuf envPath(env->m_menuPath);
		hkStringBuf testPath(test->m_path);
		testPath.replace('\\', '/');
		testPath.replace("./UnitTest/","");

		if (testPath.endsWith(env->m_menuPath) || envPath.endsWith(test->m_category) || envPath.endsWith("All Tests"))
		{
			m_tests.pushBack(test);
		}
	}
	m_currentTest = 0;

	if(overrideTest)
	{
		m_tests.pushBack(overrideTest);
	}

	s_errorText = &m_error.m_errorBuffer;

}

TestDemo::~TestDemo()
{
	// Clear test function
	hkTestReportFunction = HK_NULL;


	hkcout.printf("[%i passes, %i fails] ('F'ailure, 'W'arning, 'A'ssert, 'E'rror)\n", m_numPasses, m_numFails);
	s_errorText = HK_NULL;
	m_env->m_exitCode =  m_numFails > 0;
}

hkDemo::Result TestDemo::stepDemo()
{
	// Window dressing
	{
		int windowLines = m_env->m_textDisplay->getNumVisibleLines(m_env->m_window);
		const char* p = m_passString.cString();
		int textLines = 0;
		while(*p)
		{
			textLines += *p++ == '\n';
		}

		{
			m_env->m_textDisplay->outputText( nthLine(m_testString, m_firstLineShown), 70, 40);
			m_env->m_textDisplay->outputText( nthLine(m_failString, m_firstLineShown), 40, 40, 0xff0000);
			m_env->m_textDisplay->outputText( nthLine(m_passString, m_firstLineShown), 40, 40, 0x00ff00);
		}

		if( textLines + 6 > windowLines )
		{
			if(m_firstLineShown > 0)
			{
				m_env->m_textDisplay->outputText("^\n^", 10, 40);
				if( m_env->m_gamePad->isButtonPressed(HKG_PAD_DPAD_UP) )
				{

					{
						int amount = 1;
						m_firstLineShown = hkMath::max2(0, m_firstLineShown-amount);
					}
				}
			}

			if( textLines + 6 - m_firstLineShown > windowLines )
			{
				m_env->m_textDisplay->outputText("v\nv", 10, (int)m_env->m_window->getHeight() - 40);

				if( m_env->m_gamePad->isButtonPressed(HKG_PAD_DPAD_DOWN) )
				{
					{
						int amount = 1;
						m_firstLineShown = hkMath::min2(textLines+6-windowLines, m_firstLineShown+amount);
					}
				}
			}
		}
		{
			hkStringBuf s;
			s.printf("[%i passes, %i fails] ('F'ailure, 'W'arning, 'A'ssert, 'E'rror)", m_numPasses, m_numFails);
			m_env->m_textDisplay->outputText(s, 10, 10);
		}
	}

	// Run tests
	if (m_currentTest < m_tests.getSize())
	{
		const hkTestEntry* currentTest = m_tests[m_currentTest];

		hkError* savedError = HK_NULL;
		if( m_autoRecoverFromErrors )
		{
			// change error handler to attempt to continue
			savedError = &hkError::getInstance();
			savedError->addReference();
			hkError::replaceInstance( &m_error );
		}
		
		m_currentTestOk = true;
		s_testGame = this;
		testRun(currentTest);

		// restore default error handler
		if( savedError )
		{
			m_error.addReference();
			hkError::replaceInstance(savedError);
		}

		if( m_currentTestOk )
		{
			m_numPasses++;
			m_passString += "O";
		}
		else
		{
			m_numFails++;
		}
		m_passString += "\n";
		m_failString += "\n";

	}

	// Next test
	m_currentTest++;

	// Finished
	if (m_currentTest == m_tests.getSize())
	{
		// this out put needs to match "[HKTEST FINISH]\n" or the python script will not
		// be able to find the finish tag
		hkprintf( "[HKTEST FINISH]\n" );
		hkprintf("[%i passes, %i fails]\n", m_numPasses, m_numFails);
		HK_REGRESSION_REPORT( "Unit Tests Failures", "%", 100.0f - 100.0f * hkReal( m_numPasses ) / hkReal ( m_numPasses + m_numFails ) );
		if (m_env->m_options->m_renderer
			&& m_env->m_options->m_renderer[0] == 'n')
		{
			return DEMO_STOP;
		}
	}

	return DEMO_OK;
}

void TestDemo::testRun(const hkTestEntry* entry)
{
	const char* name = entry->m_name;
	m_testString += entry->m_name;
	m_testString += "\n";

	m_error.m_errorBuffer = "";

	if( setjmp(s_jumpBuffer) == 0 )
	{
		pushDoubleConversionCheck(true);

		(*entry->m_func)();

		popDoubleConversionCheck();
	}
	else
	{
        //entry-
		hkStringBuf path( entry->m_path );
		path.replace( "Test/UnitTest", ".\\" );
		path.replace( "/", "\\" );
		m_error.m_errorBuffer.appendPrintf("%s (%i) : '%s' was aborted\n", __FILE__, __LINE__, name);
	}

	if (m_error.m_errorBuffer.getLength()!=0)
	{
		hkprintf("[HKTEST BEGIN %s]\n", entry->m_name);
		hkprintf("%s", m_error.m_errorBuffer.cString());
		hkprintf("[HKTEST END]\n");
	}
	hkcout.flush();
}


void TestDemo::failCurrentTest(FailReason f)
{
	if(m_currentTestOk)
	{
		m_currentTestOk = false;
		const char* fails[FAIL_MAX] = { "F", "A", "E" };
		m_failString += fails[f];
	}
}

static void errorReport(const char* msg, void* errorReportObject)
{
	hkprintf( "%s", msg );
}

TestDemoError::TestDemoError() : hkDefaultError( ( hkErrorReportFunction )( errorReport ) ), m_owner(HK_NULL)
{
}

int TestDemoError::message(Message msg, int id, const char* description, const char* file, int line)
{
	if( isEnabled(id) )
	{
		switch (msg)
		{
			case hkDefaultError::MESSAGE_REPORT:
				if (id > 0)
				{
					m_errorBuffer.appendPrintf("%s (%i) : Report 0x%x: %s\n", file, line, id, description);
				}
				break;
			case hkDefaultError::MESSAGE_ASSERT:
			{
				m_owner->failCurrentTest(TestDemo::FAIL_ASSERT);
				hkStringBuf mg( description );
				mg.replace( "\n", "; " );
				m_errorBuffer.appendPrintf("%s (%i) : assert error 0x%x: %s\n", file, line, id, mg.cString());
				longjmp(s_jumpBuffer, 1);
				break;
			}
			case hkDefaultError::MESSAGE_ERROR:
			{
				m_owner->failCurrentTest(TestDemo::FAIL_ERROR);
		
				hkStringBuf mg( description );
				mg.replace( "\n", "; " );
				m_errorBuffer.appendPrintf("%s (%i) : fatal error 0x%x: %s\n", file, line, id, mg.cString());				
				longjmp(s_jumpBuffer, 1);
				break;
			}
			default:
			{
					// suspend warnings fired from:
					// - hkRigidBody::checkPerformance
				if ( id == 0x2ff8c16f || id == 0x34df5494 )
				{
					break;
				}
		
				m_owner->m_passString += "W";
				hkStringBuf mg( description );
				mg.replace( "\n", "; " );
				m_errorBuffer.appendPrintf("%s (%i) : warning 0x%x: %s\n", file, line, id, mg.cString());

				break;
			}
		}
	}
	return 0;
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
