/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */
#include <Demos/demos.h>



HWND GetConsoleHwnd(void)
{

	// Win2K or higher:
	return GetConsoleWindow();

}

void adjustConsoleWindow(const hkDemoFrameworkOptions& options)
{
	// Muck with console before init of hkg to stop interference with fullscreen mode (Esp in DX10)
	RECT visible;
	::SystemParametersInfo(SPI_GETWORKAREA, 0, &visible, 0);
	if ( !options.m_windowed || (options.m_windowed && options.m_repositionConsole) )
	{
		HWND consoleWindow = GetConsoleHwnd();
		while(!consoleWindow)
		{
			::Sleep(10);
			consoleWindow = GetConsoleHwnd();
		}

		while (!::ShowWindow(consoleWindow, SW_HIDE)) // wait until the console actual apeared, then hide it
		{
			Sleep(10);
		}

		// Now set our actual state:
		if (options.m_windowed && options.m_repositionConsole)
		{
			int consoleTop = visible.top + options.m_yPos + options.m_height + 10;
			SetWindowPos( GetConsoleHwnd(), NULL,
				visible.left + options.m_xPos, consoleTop,
				options.m_width, visible.bottom - consoleTop, 0 );
			ShowWindow(consoleWindow, SW_SHOWNORMAL);
		}
		else if (!options.m_windowed)
		{
			//	ShowWindow(consoleWindow, SW_HIDE);
		}
		else
		{
			ShowWindow(consoleWindow, SW_SHOWNORMAL);
		}
	}
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
