/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */
#include <Demos/demos.h>
#include <Demos/DemoCommon/DemoFramework/hkDemoFrameworkOptions.h>
#include <Demos/DemoCommon/DemoFramework/hkPerformanceCounterUtility.h>

#include <Common/Base/System/Io/IStream/hkIStream.h>

hkDemoFrameworkOptions::hkDemoFrameworkOptions()
:	m_windowed(true),
	m_enableShadows(false), // disable by default (even on PC as some lower Nvidia cards claim to suppot fully but don't quite)
	m_forceNoShadows(false), // allow demos to turn them on if they like, even if m_enableShadows if off generally.
	m_shadowMapRes(0), // 0 == use default platform size
	m_enableMsaa(false), // Multisampled Anti Aliasing
	m_msaaSamples(4), // 4x, 8x, 16x etc
	m_msaaQuality(0), // Different quality and sample values can trigger different h/w modes. 0 == default
	m_enableVsync(false), // Vertical Sync (Vblank) support.
	m_vsyncInterval(1),
	m_forceKeyboardGamepad(false), // if true, on pc, even if gamepad found, use keyboard to fake one.
	m_width(1280),
	m_height(720),
	m_xPos(20),
	m_yPos(20),
	m_repositionConsole(false),
	m_invertFlyMode(false),
	m_trackballMode(0),
	m_debugger(false),
	m_enableVirtualFramebuffer(false),
	m_industrial(false),
	#if HK_PLATFORM_IS_CONSOLE
	m_lockFps(0), // consoles don't need framelock.
	#else
	m_lockFps(60),
	#endif
	m_showFps(false),
	m_maxIterations(-1),
	m_defaultDemo(HK_NULL), 
	m_windowTitle("Havok"),
	m_masterFile(HK_NULL),
	#if defined( HK_ATOM )
		m_renderer("ogl"), // OGL is supported on Atom powered netbooks     XXXX try OGLES and OGLES2 instead
	#elif defined(HK_PLATFORM_UNIX) || defined(HK_PLATFORM_MAC386)
		m_renderer("ogles2"), // Try OGLES2 (which uses GLSL shaders) on Unix if it can (will check shaders and fallback)
	#elif defined(HK_PLATFORM_SIM_PPU)
		m_renderer("ogls"), // OGLS is the PS3 renderer, so use that by default on PC for Simulation runs. Runs best on NV cards
	#else
		m_renderer("d3d9s"), // DirectX9S the default on PC (and console native renderer on all else)
	#endif
	m_multiGpu(false),
	m_forceCpu(false),
	m_numSaveFrames(0),
	m_saveFrames(false),
	m_statsDir(HK_NULL),
	m_overrideFileDir(HK_NULL),
	m_enableWiiFilewriter(false),
	m_statBarX(0),
	m_statBarY(1),
	m_statBarScreenFraction(5),
	m_statBarStartTime(17),
	m_enablePerformanceCounter( false ),
	m_perfomanceCounterOption(hkPerformanceCounterUtility::IDCACHE_MISSES_PENALTY),
	m_fpuExceptionFlags(0),
	m_graphicsDevice( unsigned(-1) ),
	m_argc(0),
	m_argv(HK_NULL),
	m_forceCompiledShaders(false),
	m_windowHint(0),
	m_runLastDemo(false),
	m_runNextDemo(false),
	m_bootstrapDemoIndex(-1),
	m_anisotropicFiltering(false),
	m_edgedFaces(false),
	m_masterSoundVolume(100),
	m_replayType(REPLAY_NONE),
	m_inputFilename(HK_NULL),
	m_saveMemoryStatistics(false),
	m_enableWiiLockedCache(false),
	m_recordMovie(false),
	m_enableExceptionHandler(false)
{
	hkHardwareInfo info;
	hkGetHardwareInfo(info);
	m_numThreads = info.m_numThreads;
	m_forceMT = m_numThreads > 1;

	m_numSpus = 0;
	m_useSpuThreads = false;
	m_attributes[0] = 0;
	m_renderParallelWithSimulation = false;
}

hkDemoFrameworkOptions::~hkDemoFrameworkOptions()
{
}

void tokenizeArgs(const char* src, int &argc, char** &argv);
void tokenizeArgs(const char* src, int &argc, char** &argv)
{
	char *bp = const_cast<char*>(src);
	while (*bp) {
		char *start = HK_NULL;

		// pass up leading spaces
		while (*bp == ' ')
			bp++;

		// if we get to the end of the string after reading spaces then quit
		if ( *bp == '\0' )
		{
			break;
		}

		// handle a quoted string
		if ( *bp == '\"' )
		{
			bp++;
			start = bp;

			while (*bp && *bp != '\"')
				bp++;

		}
		else
		{
			start = bp;

			while (*bp && *bp != ' ')
				bp++;
		}

		argv[argc++] = start;

		// only increment the pointer if we are not at the end of the string
		if (*bp)
			*bp++ = '\0';
	}
}

#define HK_FPU_EXCEPTION_MASK ((unsigned int) ~(EM_ZERODIVIDE | _EM_DENORMAL))

void hkDemoFrameworkOptions::parse(int argc, const char** argv, int firstArg)
{
	m_argc = argc;
	m_argv = argv;

	int i = 0; // 0 so that we get the first arg in hkdemo.cfg
	while( i < argc )
	{
		if(argv[i][0] == '-')
		{
			switch( hkString::toLower(argv[i][1]))
			{
			case '?': //print out the options available
				{
					printf("\nHavok demo framework command line options:\n");
					printf("\t\t -a            Assign a user attributes string to the demo\n");
					printf("\t\t -norepos      Disable reposition of console window on startup [PC, default]\n");
					printf("\t\t -repos        Reposition of console window on startup [PC]\n");
					printf("\t\t -d            Run the VDB server\n");
					printf("\t\t -g DemoName   Run the given demo only\n");
					printf("\t\t -lastdemo     When running bootstrap demos (e.g. -g bootstrapall), start from the last demo run by the bootstrap\n");
					printf("\t\t -nextdemo     When running bootstrap demos (e.g. -g bootstrapall), start from the demo after the last demo run by the bootstrap\n");
					printf("\t\t -bdi          When running bootstrap demos (e.g. -g bootstrapall), start from this index\n");
					printf("\t\t -r {ogl,d3d9,d3d9s,d3d8,null}  Attempt to use the given renderer. ");
					printf("\t\t               Must be last option if used. [mainly PC, null allowed on all]\n");
					printf("\t\t -trackball    Use trackball style navigation (default navigation is fly mode):\n");
					printf("\t\t               can be like Max (-trackballMax), Maya (-trackballMaya) or normal (-trackball).\n");
					printf("\t\t -invertfly    Use inverted fly mode (flight sim style, forward/up is pitch down).\n");
					printf("\t\t -f            Force fullscreen mode [PC]\n");
					printf("\t\t -w            Force windowed mode [PC]\n");
					printf("\t\t -shadows      Force shadows on (using shadow maps) in all applicable demos on \n");
					printf("\t\t -smapXXX      Set shadow map resolution to XXX \n");
					printf("\t\t -noshadows    Force shadows off\n");
					printf("\t\t -msaa		   Force MSAA on \n");
					printf("\t\t -msaaQualityXX  Turn MSAA on with Quality set to XX \n");
					printf("\t\t -msaaSamplesXX	 Turn MSAA on with Samples set to XX \n");
					printf("\t\t -nomsaa       Force MSAAoff \n");
					printf("\t\t -vsync        Force VSYNC on \n");
					printf("\t\t -vsyncIntervalXX   Turn VSYNC on with Interval of XX (usually 1..4)\n");
					printf("\t\t -novsync      Force VSYNC off \n");
					printf("\t\t -aniso        Turn anisotropic texture filtering on\n");
					printf("\t\t -sli          Use multiple GPUs if available\n");
					printf("\t\t -fakegamepad  Force keyboard input to override gamepad (fake gamepad)[PC]\n");
					printf("\t\t -record FILE   Record all input to FILE.\n");
					printf("\t\t -playback FILE Playback input from FILE\n");
					printf("\t\t -lDDD         Force demo not to exceed DDD Hz (lock framerate) using a software wait[PC]\n");
					printf("\t\t -fps          Show the fps in thw upper left corner\n");
					printf("\t\t -xDDD        Set the window width(DDD pixels) (no space) [PC]\n");
					printf("\t\t -yDDD        Set the window height(DDD pixels)  (no space) [PC]\n");
					printf("\t\t -xpDDD       Set the window x position (DDD pixels of the virtual screen)  (no space) [PC]\n");
					printf("\t\t -ypDDD       Set the window y position (DDD pixels of the virtual screen)  (no space) [PC]\n");
					printf("\t\t -i (num)      Run the demo for (num) iterations.\n");
					printf("\t\t -m Filename   Set the master resource file for demos [PS2]\n");
					printf("\t\t -st           force the demo(s) to run in single-threaded simulation mode\n");
					printf("\t\t -mt           force the demo(s) to run in multi-threaded simulation mode, optionally specifying the number of threads\n");
					printf("\t\t               For example -mt4 will attempt to use 4 threads.\n");
					printf("\t\t -mtr          force the demo(s) to run in multi-threaded simulation mode, in parallel with rendering\n");
					printf("\t\t -spu(num)     Set the number of SPUs used to (num). -mt must be set for SPUs to be used. \n");
					printf("\t\t -sputhread	   Use spuThreads instead of SPURS. \n");
					printf("\t\t -c	           Run using the debug mem manager [Debug only, not in GCC or GameCube builds, not in hkdemo.cfg]\n");
					printf("\t\t -memstat      Save memory statistics after demo is finished. -c must be set also. \n");
					printf("\t\t -p{i,d,l,f}   Enable performance counter and set it to count instruction cache(i), d cache(d), load-hit-store(l), and instr flushed (f), or combo of them.\n");
					printf("\t\t               or dcache (pd) misses [PS2]\n");
					printf("\t\t -h{VGA,480p,480i,576p,576i,720p,720i,1080p,1080i}  Set the display hint \n");
					printf("\t\t -device{0,1,2,3} Set the display device (adapter) to use on multi monitor PCs \n");
					printf("\t\t -rl(0,1,2,3,4,5) Set the reporting level 0 = NONE, 5 = ALL");
					printf("\t\t -video        Dump all displayed frames to disk\n");
					printf("\t\t -volumeXXX    Set Master sound volume (100 == Normal)\n");
					printf("\t\t -wiifw        Enable filewriter (cannot use VDB if enabled) [Wii]\n");
					printf("\t\t -rm FILE      Record .AVI movie to FILE\n");
					printf("\t\t -exceptionHandler  Enable exception handler\n");
					printf("\t\t -fpu          Enable FPU exceptions (Win32 only) \n");
					break;
				}

			case 'a':
				{
					if (hkString::strCasecmp(argv[i], "-aniso") == 0)
					{
						m_anisotropicFiltering = true;
					}
					else
					{
						hkString::snprintf(m_attributes, 50, &argv[i][2]);
					}
					break;
				}

			case 'b': // dont re-boot iop
				{
					// note that the following expression will not read off the end of the string
					// (although it looks suspicious) due to short-circuit expression evaluation
					if ((argv[i][2] == 'i') &&
						(argv[i][3] == 'n') &&
						(argv[i][4] == '\0' ) ) // -bin
					{
						m_forceCompiledShaders = true;
					}
					else if (argv[i][2] == 'd' && argv[i][3] == 'i' && ++i < argc) // -bdi (bootstrapDemoIndex)
					{
						m_bootstrapDemoIndex = hkString::atoi(argv[i]);
					}
					break;
				}
				// case 'c': check memory - handled before hkBaseSystem::init.
			case 'd': // debugger
				{

					// -device{0,1,choose} Set the display device (adapter) to use on mutlimon PCS \n");
					if ( argv[i][2] && argv[i][3] && (argv[i][2] == 'e') && (argv[i][3] == 'v') )
					{
						if (argv[i][5] && argv[i][6] && argv[i][7])
						{
							if (argv[i][7] == '0')
								m_graphicsDevice = 0;
							else if (argv[i][7] == '1')
								m_graphicsDevice = 1;
							else if (argv[i][7] == '2')
								m_graphicsDevice = 2;
							else if (argv[i][7] == '3')
								m_graphicsDevice = 3;
						}
					}
					// -d(ebugger)
					else
					{
						m_debugger = true;
					}
					break;
				}
			case 'e': // exceptionHandler
				{
					m_enableExceptionHandler = true;
					break;
				}
			case 'f': // fullscreen
				{
					// -fakegamepad
					if ( argv[i][2] && (argv[i][2] == 'a') )
					{
						m_forceKeyboardGamepad = true;
					}
					// -forcecpu
					else if ( argv[i][2] && (argv[i][2] == 'o') )
					{
						m_forceCpu = true;
					}
					else if ( argv[i][2] && (argv[i][2] == 'p') ) // fps or fpu
					{
						if ( argv[i][3] && (argv[i][3] == 's') )
						{
							m_showFps = true;
						}
						else
						{
							m_fpuExceptionFlags = HK_FPU_EXCEPTION_MASK;
						}

					}
					else // assume -f or -fullscreen etc
					{
						m_windowed = false;
					}
					break;
				}
			case 'g':
				{
					if(++i < argc)
					{
						m_defaultDemo = argv[i];
					}
					break;
				}
			case 'i': // Iterations
				{
					if (argv[i][2] && (hkString::toLower(argv[i][2]) == 'n')) // -invert
					{
						m_invertFlyMode = true;
					}
					else if(++i < argc)
					{
						m_maxIterations = hkString::atoi(argv[i]);
					}
					break;
				}
			case 'l':
				{
					// -lastdemo
					if ( argv[i][2] && (argv[i][2] == 'a') )
					{
						m_runLastDemo = true;
					}
					else
					{
						m_lockFps = -1;
						if( argv[i][2] != HK_NULL) // '-l60'
						{
							m_lockFps = hkString::atoi(argv[i]+2);
						}
						else if( i+1 < argc && argv[i+1][0] != '-') // '-l' '60'
						{
							++i;
							m_lockFps = hkString::atoi(argv[i]);
						}
						if( m_lockFps == -1) // '-l' or parse error
						{
							m_lockFps = 60;
						}
					}
					break;
				}
			case 'm':
				{
					// -mt (force multithreaded)
					if ( argv[i][2] == 't' )
					{
						m_forceMT = true;
						if ( argv[i][3] >= '1' && argv[i][3] <= '9')
						{
							m_numThreads = argv[i][3] - '0';
						}
						// -mtr (run rendering in parallel with simulation)
						if ( argv[i][3] == 'r' )
						{
							m_renderParallelWithSimulation = true;
						}
					}
					else if ( argv[i][2] == 's' )
					{
						m_enableMsaa = true;
						if ((argv[i][3] == 'a') && (argv[i][4] == 'a') && argv[i][5] )
						{
							if ( (argv[i][5] == 'Q') || ( argv[i][5] == 'q') )
							{
								// -msaaQualityXX
								m_msaaQuality =  hkString::atoi(argv[i]+12);
							}
							else if ( (argv[i][5] == 'S') || ( argv[i][5] == 's') )
							{
								// -msaaSamplesXX
								m_msaaSamples =  hkString::atoi(argv[i]+12);
							}
						}
					}
					else if ( argv[i][2] == 'e' ) // -memstat
					{
						m_saveMemoryStatistics = true;
					}
					else // assume -m
					{
						if(++i < argc)
						{
							m_masterFile = argv[i];
						}
					}
					break;
				}
			case 'n':
				{
					if ( argv[i][2] && (argv[i][2] == 'e') ) // -nextdemo
					{
						m_runNextDemo = true;
					}
					else if ( argv[i][2] && (argv[i][2] == 'o') && argv[i][3] && (argv[i][3] == 'r')) // -norepos
					{
						m_repositionConsole = false;
					}
					else if ( argv[i][2] && argv[i][3] && (argv[i][3] == 'm') ) // -nomsaa
					{
						m_enableMsaa = false;
					}
					else if ( argv[i][2] && argv[i][3] && (argv[i][3] == 'v') ) // -novsync
					{
						m_enableVsync = false;
					}
					else if ( argv[i][2] && argv[i][3] && (argv[i][3] == 's') )// -noshadows
					{
						m_enableShadows = false;
						m_forceNoShadows = true;
					}
					break;
				}
			case 'o':
				{
					if(++i < argc)
					{
						m_overrideFileDir = argv[i];
					}
					break;
				}


			case 'p': // p{i|d|l|lp|f}
				{
					if (hkString::strCasecmp(argv[i], "-playback") == 0)
					{
						if (++i < argc)
						{
							m_replayType = REPLAY_PLAYBACK;
							m_inputFilename = argv[i];
						}
					}
					else
					{
						m_enablePerformanceCounter = true;
						if (argv[i][2] && (argv[i][2] != ' ') )
						{
							int idx = 1;
							m_perfomanceCounterOption = hkPerformanceCounterUtility::DISABLE; //0
							while (++idx >= 2)
							{
								switch (argv[i][idx])
								{
								case 'i' :
									m_perfomanceCounterOption |= hkPerformanceCounterUtility::ICACHE_MISSES_PENALTY;
									break;
								case 'd' :
									m_perfomanceCounterOption |= hkPerformanceCounterUtility::DCACHE_MISSES_PENALTY;
									break;
								case 'l' :
									if (argv[i][idx+1] =='p')
									{
										m_perfomanceCounterOption |= hkPerformanceCounterUtility::LOAD_HIT_STORE_PENALTY;
										++idx;
									}
									else
										m_perfomanceCounterOption |= hkPerformanceCounterUtility::LOAD_HIT_STORE;
									break;
								case 'f' :
									m_perfomanceCounterOption |= hkPerformanceCounterUtility::INSTRUCTIONS_FLUSHED;
									break;
								default:
									idx = 0; break;
								}
							}
						}
					}
					break;
				}
			case 'r':
				{
					if (hkString::strCasecmp(argv[i], "-repos") == 0) //-repos windows
					{
						m_repositionConsole = true;
					}
					else if (hkString::strNcasecmp(argv[i], "-rl", 3) == 0 && argv[i][3] ) //-rl# reporting level
					{
						m_reportingLevel = argv[i][3] - '0';
						m_reportingLevel = hkMath::clamp( (int)m_reportingLevel, (int)hkDemoEnvironment::REPORT_OFF, (int)hkDemoEnvironment::REPORT_ALL );
					}
					else if (hkString::strCasecmp(argv[i], "-record") == 0)
					{
						if (++i < argc)
						{
							m_replayType = REPLAY_RECORD;
							m_inputFilename = argv[i];
						}
					}
					else if (hkString::strCasecmp(argv[i], "-rm") == 0) //-rm record move to file
					{
						if (++i < argc)
						{
							m_recordMovie = true;
							m_movieFilename = argv[i];
						}
					}
					else if(++i < argc) //// renderer
					{
						m_renderer = argv[i];
						if( argv[i][0] == 'n' )
						{
							m_lockFps = 0; // turn off frame lock for null renderer
						}
					}
					break;
				}
			case 's': // set the stats output directory or shadows
				{
					// -st singlethreaded
					if ( argv[i][2] == 't' )
					{
						if (argv[i][3] == 'a') // -statbars[tart], -statbarx, -statbary, -statbarf[raction] all followed by a space then the int
						{
							switch (argv[i][8])
							{
							case 's':
								if(++i < argc)
								{
									m_statBarStartTime =  hkString::atoi(argv[i]);
									if (m_statBarStartTime < 1 || m_statBarStartTime > 255)
									{
										m_statBarStartTime = 17;
									}
								}
								break;

							case'x':
								if(++i < argc)
								{
									m_statBarX =  hkString::atoi(argv[i]);
									if (m_statBarX < 0 || m_statBarStartTime > 10000)
									{
										m_statBarX = 0;
									}
								}
								break;

							case 'y':
								if(++i < argc)
								{
									m_statBarY =  hkString::atoi(argv[i]);
									if (m_statBarY < 0 || m_statBarY > 10000)
									{
										m_statBarY = 0;
									}
								}
								break;

							case 'f':
								if(++i < argc)
								{
									m_statBarScreenFraction =  hkString::atoi(argv[i]);
									if (m_statBarScreenFraction < 1 || m_statBarScreenFraction > 100)
									{
										m_statBarScreenFraction = 5;
									}
								}
								break;
							}
						}
						else
						{
							// -st
							m_forceMT = false;
							m_numThreads = 1;
						}
						break;
					}

					// -spu (set num spus, spuThread)
					if ( ( argv[i][2] == 'p' ) && ( argv[i][3] == 'u' ) )
					{
						if ( argv[i][4] == 't' )
						{
							m_useSpuThreads = true;
						}
						else
						{
							if ( argv[i][4] >= '0' && argv[i][4] <=	 '5')
							{
								m_numSpus = argv[i][4] - '0';
							}
						}
						break;
					}
					// shadows
					if (argv[i][2] && (hkString::toLower(argv[i][2]) == 'h'))
					{
						m_enableShadows = true;
						m_forceNoShadows = false;
					}
					// -smapRES
					else if ( argv[i][2] && (hkString::toLower(argv[i][2]) == 'm') && argv[i][3] && argv[i][4] && argv[i][5] )
					{
						m_shadowMapRes =  hkString::atoi(argv[i]+5);
					}
					// sli
					else if (argv[i][2] && (hkString::toLower(argv[i][2]) == 'l'))
					{
						m_multiGpu = true;
					}
					// else stats
					else if(++i < argc)
					{
						m_statsDir = argv[i];
					}
					break;
				}
			case 't':
				{
					if ( argv[i][2] != HK_NULL) // '-trackball'
					{
						const char* name = &(argv[i][1]);
						if ( hkString::strNcasecmp(name, "trackball", 9) == 0)
						{
							m_trackballMode = 1;
							const char* style = &(argv[i][10]);
							if ( style[0] )
							{
								if (hkString::strNcasecmp(style, "Maya", 4) == 0)
									m_trackballMode = 3;
								else if (hkString::strNcasecmp(style, "Max", 3) == 0)
									m_trackballMode = 2;
							}
						}
					}
					else if(++i < argc) // -t windowname
					{
						m_windowTitle = argv[i];
					}
					break;
				}
			case 'v':  // -video
				{
					if (argv[i][2] &&  argv[i][2] == 'i')
					{
						m_saveFrames = true;
					}
					else if (argv[i][2] &&  argv[i][2] == 'o') // -volumeXXX
					{
						m_masterSoundVolume = hkString::atoi(argv[i]+7);
					}
					if (argv[i][2] && ((argv[i][2] == 'n') || (argv[i][2] == 'f')) ) // -vnc or -vfb
					{
						m_enableVirtualFramebuffer = true;
					}
					else if (argv[i][2] && argv[i][2] == 's') // -vsync
					{
						m_enableVsync = true;
						if ( (argv[i][6] == 'I') || ( argv[i][6] == 'i') )
						{
							// -vsyncIntervalXX
							m_vsyncInterval =  hkString::atoi(argv[i]+14);
						}
					}
					break;
				}
			case 'w':
				{
					if ( argv[i][2] == 'i' ) // '-wiifw'
					{
						m_enableWiiFilewriter = true;
					}
					else
					{
						m_windowed = true; // // windowed
					}
					break;
				}
			case 'x': // x res (width)
				{
					if (argv[i][2] == 'p') // '-xp640'
					{
						m_xPos =  hkString::atoi(argv[i]+3);
					}
					else if( argv[i][2] != HK_NULL) // '-x640'
					{
						m_width = hkString::atoi(argv[i]+2);
					}
					break;
				}
			case 'y': // y res (height)
				{
					if (argv[i][2] == 'p') // '-xp640'
					{
						m_yPos =  hkString::atoi(argv[i]+3);
					}
					else if( argv[i][2] != HK_NULL) // '-y480'
					{
						m_height = hkString::atoi(argv[i]+2);
					}
					break;
				}
			case 'h':
				{
					// -h{VGA,480p,480i,576p,576i,720p,720i,1080p,1080i}
					if( argv[i][2] != HK_NULL)
					{
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "VGA")==0)   ? HKG_WINDOW_HINT_VGA : 0;
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "480p")==0)  ? HKG_WINDOW_HINT_480p : 0;
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "480i")==0)  ? HKG_WINDOW_HINT_480i : 0;
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "576p")==0)  ? HKG_WINDOW_HINT_576p : 0;
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "576i")==0)  ? HKG_WINDOW_HINT_576i : 0;
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "720p")==0)  ? HKG_WINDOW_HINT_720p : 0;
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "720i")==0)  ? HKG_WINDOW_HINT_720i : 0;
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "1080p")==0) ? HKG_WINDOW_HINT_1080p : 0;
						m_windowHint |= (hkString::strCasecmp(&argv[i][2], "1080i")==0) ? HKG_WINDOW_HINT_1080i : 0;
					}
					break;
				}

			default:
				{
					//hkprintf("option `%s' was not understood", argv[i]);
				}
			}
		}
		else
		{
			//hkprintf("option `%s' was not understood", argv[i]);
		}

		++i;
	}
#if defined FORCE_STATS_GENERATION
	{
		m_renderer = "n";
		m_lockFps = 0;
		m_defaultDemo = "DemoCommon/Utilities/Bootstrap/BootstrapStats";
	}
#endif
}

static const char* _temp_argv[128];
void hkDemoFrameworkOptions::parseFile(const char* cfgFile)
{
	// open the cmdline settings file
	hkIstream stream(cfgFile);

	// If we have a command line file
	if (stream.isOk())
	{
		// copy argv so we can expand it
		for( int i = 0; i < m_argc; i++ )
		{
			_temp_argv[i] = m_argv[i];
		}
		m_argv = _temp_argv;
		int oldArgc = m_argc;

		// read the settings file
		// comment lines start with ;
		// can have arguments spread over multiple lines
		// or all arguments can be on same line

		int curLen = 0;
		while( stream.isOk() )
		{
			HK_ASSERT2(0x1d4eaa89, curLen < 1024, "hkdemo.cfg command line arguments has exceeded maximum number of allowed chars (1024)");

			// curGlobalLine holds a pointer to the next free position in the m_argvBuffer
			char* curGlobalLine =  m_argvBuffer + curLen;

			stream.getline( curGlobalLine, 255 );

			// comment lines are ignored
			if( curGlobalLine[0] == ';' )
			{
				continue;
			}

			hkStringBuf curLine( curGlobalLine );

			if (curLine.getLength() > 0)
			{
				// trim whitespace at end
				char trim = curLine[curLine.getLength() - 1];
				while( (curLine.getLength() > 0) && ((' ' == trim) || ('\r' == trim) || ('\n' == trim)) )
				{
					curLine.slice( 0, curLine.getLength() - 1 );
					trim = curLine[curLine.getLength() - 1];
				}
			}

			int cr = curLine.getLength();

			// ignore empty lines
			if( 0 == cr )
			{
				continue;
			}

			// hold onto the lines with cmd line args
			curGlobalLine[cr] = 0;

			// tokenize the line using ' ', increment argc and add each token to argv
			tokenizeArgs(curGlobalLine, m_argc, (char**&)m_argv);

			curLen += cr + 1;
		}

		// set the last argument to null
		m_argv[m_argc] = HK_NULL;

		// parse new options (but not the ones that were already parsed in main())
		parse(m_argc, m_argv, oldArgc);
	}
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
