/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */
#include <Demos/demos.h>
#include <Demos/DemoCommon/Utilities/GameUtils/TweakerUtils.h>
#include <Demos/DemoCommon/Utilities/CameraUtils/CameraUtils.h>

#include <Common/Visualize/hkDebugDisplay.h>
#include <Graphics/Bridge/DisplayHandler/hkgDisplayHandler.h>

hkDemoEnvironment* s_debugEnvironmentHandle = HK_NULL;

static void tweak(void *tweakee, const hkClass* klass, TweakerUtils::HideMemberFunc hideMembers, hkDemoEnvironment* debugEnvironmentHandle)
{
	DemoMouseTweaker::MouseTweakerSettings settings;
	settings.m_demoEnvironment = debugEnvironmentHandle;
	settings.m_hideMembers = hideMembers;
	settings.m_klass = klass;
	settings.m_tweakee = tweakee;
	//settings.m_tweakName = tweakName;

	DemoMouseTweaker::tweak( settings );
}

// A utility function useful for debugging inner loops
// Declared in Source\Common\Visualize\hkDebugDisplay.h
debugRenderNow::~debugRenderNow()
{
	HK_ASSERT(0, s_debugEnvironmentHandle != HK_NULL);

	hkgWindow* window = s_debugEnvironmentHandle->m_window; 

	if (m_cameraSet)
	{
		hkgCamera* cam = window->getCurrentViewport()->getCamera();
		cam->setTo( (float*)&m_cameraTo );
		cam->computeModelView();
	}

	const bool oldHoldTextForDebug = s_debugEnvironmentHandle->m_textDisplay->m_holdTextForDebug;
	s_debugEnvironmentHandle->m_textDisplay->m_holdTextForDebug = true;
	const char* title = m_title ? m_title
		: m_wait ? "Debug display (Waiting)" : "Debug display";
	s_debugEnvironmentHandle->m_textDisplay->outputText(title, 20, 0);

	hkBool showKeys = false;
	hkBool startedInRenderLoop = s_debugEnvironmentHandle->m_inRenderLoop;
	hkBool needClear = !startedInRenderLoop;
	while ( window->peekMessages() == HKG_WINDOW_MSG_CONTINUE )
	{
		// Do title text
		{
			s_debugEnvironmentHandle->m_textDisplay->wipeText(); // Clear text
			const hkgKeyboard& key = s_debugEnvironmentHandle->m_window->getKeyboard();
			if( key.wasKeyPressed(HKG_VKEY_SPACE) || key.getKeyState(HKG_VKEY_SHIFT)  )
			{
				// Indicate keypress has been received so we're going to exit from display and
				// return to running code - ie. leave the text ('Running') to indicate we have exited display
				s_debugEnvironmentHandle->m_textDisplay->outputText("(Running)...", 20, 20);	
			}
			s_debugEnvironmentHandle->m_textDisplay->outputText(title, 20, 0);	// Put back title 
		}

		// If we want a render callback, clear current display and callback
		if( m_callbacks && m_callbacks->m_doRenderCallback)
		{
			s_debugEnvironmentHandle->m_displayHandler->clear(); // clear debug display
			m_callbacks->render();
		}

		// If we want to tweak some (render) params, clear test, display tweakable and tweak it
		if( m_callbacks && m_callbacks->m_tweakee &&  m_callbacks->m_tweakeeClass)
		{
			tweak( m_callbacks->m_tweakee, m_callbacks->m_tweakeeClass, m_callbacks->m_hideMembers, s_debugEnvironmentHandle );
		}

		// If we're displaying the list of keys which do something (shift, space etc.)
		if( showKeys )
		{
			const char* keysText =	"     F1 Display this text\n" \
				"  SPACE Exit (once)\n" \
				"  SHIFT Exit (autorepeats)\n" \
				"Decimal Spew Camera details to console\n" \
				"NumPad* Center camera on display geometry\n" \
				"A-Z,a-z Pass key to callback";
			s_debugEnvironmentHandle->m_textDisplay->outputText(keysText, 20, 80);
		}

		// If we want to handle a key in some callback code - *before* rendering (maybe allow some more drawing code)
		if( m_callbacks )
		{
			const hkgKeyboard& key = s_debugEnvironmentHandle->m_window->getKeyboard();
			for( unsigned char c = 'a'; c <= 'z'; c++)
			{
				if ( key.wasKeyPressed(c) )
				{
					m_callbacks->handleKey( c );
				}
			}
			for( unsigned char c = 'A'; c <= 'Z'; c++)
			{
				if ( key.wasKeyPressed(c) )
				{
					m_callbacks->handleKey( c );
				}
			}

		}

		// Render
		if (needClear)
		{
			window->clearBuffers();
			s_debugEnvironmentHandle->m_inRenderLoop = true;
		}
		renderFrame( *s_debugEnvironmentHandle, HK_NULL );
		needClear = true;
	
		if( m_wait == false )
		{
			break;
		}

		// Handle keys
		{
			const hkgKeyboard& key = s_debugEnvironmentHandle->m_window->getKeyboard();
			if ( key.wasKeyPressed(HKG_VKEY_DECIMAL) )
			{
				CameraUtils::spewCameraDetailsToConsole( s_debugEnvironmentHandle );
			}
			if ( key.wasKeyPressed(HKG_VKEY_MULTIPLY) )
			{
				CameraUtils::centerCameraAroundDisplay( s_debugEnvironmentHandle );			
			}

			if( key.wasKeyPressed(HKG_VKEY_SPACE) || key.getKeyState(HKG_VKEY_SHIFT) )
			{
				break;
			}
			if( key.wasKeyPressed(HKG_VKEY_F1) )
			{
				showKeys = ! showKeys;
			}
		}
	}

	s_debugEnvironmentHandle->m_textDisplay->m_holdTextForDebug = oldHoldTextForDebug;
	s_debugEnvironmentHandle->m_textDisplay->wipeText();

	if (m_clearDebug)
	{
		s_debugEnvironmentHandle->m_displayHandler->clear(); // clear debug display before a potential world step
	}

	if (startedInRenderLoop)
	{
		window->clearBuffers();
		s_debugEnvironmentHandle->m_inRenderLoop = true;
	}
}

void HK_CALL debugRenderImmediate(int wait, int clear)
{
	debugRenderNow().wait( wait!=0 ).clearDebug( clear!=0 );
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
