/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_DEMOFRAMEWORK_DEMOFRAMEWORK_H
#define HK_DEMOFRAMEWORK_DEMOFRAMEWORK_H

#include <Demos/DemoCommon/DemoFramework/hkDemo.h>

struct hkDemoFrameworkOptions;
class hkDemoEnvironment;
class hkMemoryRouter;

////////////////////////////////////////////////////////////////////////////
// Main line

int HK_CALL frameworkMain(hkDemoFrameworkOptions& options, const char* startUpDemo);

// Main line calls the following:
bool frameworkInitBaseSystem( hkMemoryAllocator* base, hkDemoFrameworkOptions& options );
hkDemo* frameworkStartDemo( hkDemoEnvironment& environment, const char* startUpDemo );
hkDemo::Result frameworkStep( hkDemoEnvironment& environment, hkDemo* demo, int& stepCount );
hkResult frameworkQuitBaseSystem();

////////////////////////////////////////////////////////////////////////////
// Graphics

bool initRendererAndEnv(hkDemoEnvironment& env);
bool startRenderFrame(hkDemoEnvironment& env);
void checkFrameRate(hkDemoEnvironment& env);
void sendCurrentFrameOverNetwork(hkDemoEnvironment& env);
void tickFrame(hkDemoEnvironment& env, bool justCamera); // view not paused, used for motion blur etc to advance 'current'
void renderFrame(hkDemoEnvironment& env, hkDemo* demo);
void clearFrameData(hkDemoEnvironment& env);
void quitRendererAndEnv(hkDemoEnvironment& env);

////////////////////////////////////////////////////////////////////////////
// Misc 

// 'debug render now' support
void HK_CALL debugRenderImmediate(int wait, int clear);
extern hkDemoEnvironment* s_debugEnvironmentHandle;

// Reposition and/or hide the console window 
void adjustConsoleWindow(const hkDemoFrameworkOptions& options);


#endif //HK_DEMOFRAMEWORK_DEMOFRAMEWORK_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
