/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */
#include <Demos/demos.h>
#include <Demos/DemoCommon/DemoFramework/hkDemo.h>

#include <Graphics/Common/hkGraphics.h>

#include <Demos/DemoCommon/DemoFramework/hkDemoFramework.h>

#include <Demos/DemoCommon/DemoFramework/hkTextDisplay.h>
#include <Demos/DemoCommon/DemoFramework/hkPerformanceCounterUtility.h>
#include <Demos/DemoCommon/DemoFramework/hkDemoDatabase.h>
#include <Demos/DemoCommon/DemoFramework/hkDemoConsole.h>
#include <Demos/DemoCommon/DemoFramework/hkDefaultDemo.h>
#include <Demos/DemoCommon/Utilities/ExceptionHandler/hkExceptionHandler.h>

#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/Window/hkgWindow.h>

#include <Common/Visualize/hkVisualDebugger.h>

#include <Common/Base/Memory/System/Util/hkMemoryInitUtil.h>
#include <Common/Base/System/Error/hkDefaultError.h>
#include <Common/Base/Memory/MemoryClasses/hkMemoryClassDefinitions.h>

#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Common/Base/System/Io/Writer/hkStreamWriter.h>
#include <Common/Base/System/Io/Reader/Buffered/hkBufferedStreamReader.h>

#include <Common/Base/Memory/System/hkMemorySystem.h>
#include <Common/Base/Thread/Semaphore/hkSemaphoreBusyWait.h>

#include <Demos/DemoCommon/DemoFramework/hkPackedFileSystemSource.inl>
#include <Demos/DemoCommon/DemoFramework/hkDemoFilesystem.h>
#include <Common/Base/Memory/Allocator/Malloc/hkMallocAllocator.h>
#include <Common/Base/Config/hkProductFeatures.h>




// Enable FORCE_STATS_GENERATION to run the stats bootstrapper with the renderer switched off.
// This works for all platforms but is for Wii mostly, as the renderer can't be disabled via
// command args until file IO is supported.
// #define FORCE_STATS_GENERATION


class hkOverrideFileSystem : public hkFileSystem
{
public:

	hkOverrideFileSystem( hkFileSystem* factory, const char* override )
		: m_parent(factory), m_override(override)
	{
		m_parent->addReference();
	}
	~hkOverrideFileSystem()
	{
		m_parent->removeReference();
	}

	hkStreamReader* openReader(const char* name)
	{
		hkStringBuf override = m_override;
		const char* basename = hkString::strRchr(name, '/');
		basename = basename ? basename+1 : name;
		override += basename;
		hkStreamReader* reader = m_parent->openReader(override.cString());
		if( reader->isOk() == false )
		{
			delete reader;
			reader = m_parent->openReader(name);
		}
		else
		{
			printf("override: using %s instead of %s\n", override.cString(), name);
		}
		return reader;
	}

	hkStreamWriter* openWriter(const char* name)
	{
		return m_parent->openWriter(name);
	}

	hkFileSystem* m_parent;
	const char* m_override;
};

static void HK_CALL _demoResizeNotify(hkgWindow* w,unsigned int width, unsigned int height, void* userContext )
{
	if (userContext)
	{
		((hkDemo*)userContext)->windowResize(width, height);
	}
}

static void HK_CALL _demoDropFiles(const hkgWindow* w, unsigned int x, unsigned int y, const char* filename, void* userContext )
{
	if (userContext)
	{
		((hkDemo*)userContext)->windowDropFile(filename, x, y);
	}
}

static void HK_CALL errorReportFunction(const char* str, void*)
{
		OutputDebugStringA(str);
	printf("%s", str);
}

static hkBool32 hasOptionPrefix(char const*const* argv, int argc, const char* prefix )
{
	for( int i = 1; i < argc; ++i )
	{
		const char* s = argv[i];
		if( s && hkString::beginsWith(s, prefix) )
		{
			return true;
		}
	}
	return false;
}

bool frameworkInitBaseSystem( hkMemoryAllocator* base, hkDemoFrameworkOptions& options )
{
	hkMemoryRouter* memoryRouter;

#ifdef HK_FEATURE_PRODUCT_PHYSICS
	hkMemorySystem::FrameInfo frameInfo(6*1024*1024);	// the bridge in Havok destruction needs a large buffer
#else
	hkMemorySystem::FrameInfo frameInfo(0);
#endif

	if( hasOptionPrefix(options.m_argv, options.m_argc, "-co") )
	{
		memoryRouter = hkMemoryInitUtil::initOptimizer(base, frameInfo);
		extAllocator::initDefault();
	}
	else if( hasOptionPrefix(options.m_argv, options.m_argc, "-c") )
	{
		memoryRouter = hkMemoryInitUtil::initChecking(base, frameInfo);
		extAllocator::initChecking();
	}
	else
	{
		memoryRouter = hkMemoryInitUtil::initFreeList(base, frameInfo);
		extAllocator::initDefault();
	}

	if (memoryRouter == HK_NULL)
	{
		return false;
	}

	#if defined(HK_MEMORY_TRACKER_ENABLE)
		hkMemoryInitUtil::initMemoryTracker();
	#endif
	
	if ( hkBaseSystem::init( memoryRouter, errorReportFunction ) != HK_SUCCESS)
	{
		return false;
	}

	if(options.m_masterFile != HK_NULL)
	{
		hkStreamReader * masterFile = hkFileSystem::getInstance().openReader(options.m_masterFile);
		if (masterFile->isOk())
		{
			// For PlayStation(R)2 cdrom
			hkBool seekBug = (hkString::strNcasecmp("cdrom" , options.m_masterFile, 5) == 0);
			// Replace with the masterfile
			hkPackedFileSystem* msb = new hkPackedFileSystem(masterFile, seekBug);
			masterFile->removeReference();
			hkFileSystem::replaceInstance(msb);
		}
		else
		{
			HK_WARN( 0x2c23ee65, "Could not open master file " << options.m_masterFile );
			options.m_masterFile = HK_NULL;
		}
	}
	if( options.m_masterFile == HK_NULL ) // master not specified or not found
	{
		hkDemoFileSystem* dsb = new hkDemoFileSystem();
		hkFileSystem::replaceInstance(dsb);
		if( options.m_overrideFileDir != HK_NULL )
		{
			hkFileSystem* osb = new hkOverrideFileSystem(dsb, options.m_overrideFileDir);
			hkFileSystem::replaceInstance(osb);
		}
	}

	if ( options.m_enableExceptionHandler )
	{
		hkExceptionHandler::setExceptionHandlingEnabled( true );
	}

#ifdef ENABLE_SN_TUNER
	snTunerInit();
#endif

	return true;
}

hkResult frameworkQuitBaseSystem()
{
	hkBaseSystem::quit();
	#if defined(HK_MEMORY_TRACKER_ENABLE)
		hkMemoryInitUtil::quitMemoryTracker();
	#endif
	hkResult result = hkMemoryInitUtil::quit();
	printf("Base system shut down.\n");
	extAllocator::quit();
	return result;
}

hkDemo* frameworkStartDemo( hkDemoEnvironment& environment, const char* startUpDemo )
{
	hkDemoDatabase& database = hkDemoDatabase::getInstance();
	environment.m_window->getContext()->lock();

	hkDemo* demo = database.createDemo(startUpDemo, &environment);

	environment.m_window->setWindowResizeFunction( _demoResizeNotify, demo );
	environment.m_window->setWindowDropFileFunction( _demoDropFiles, demo );

	environment.m_window->getContext()->unlock();

	return demo;
}

hkDemo::Result frameworkStep( hkDemoEnvironment& environment, hkDemo* demo, int& stepCount )
{
	bool graphicsWindowOK = startRenderFrame(environment);

	demo->advanceFrame();

	hkDemo::Result step = demo->stepDemo();

	const hkDemoFrameworkOptions& options = *environment.m_options;

	// Automatically stop the demo if the user limit for iterations is reached.
	if (options.m_maxIterations > 0)
	{
		stepCount++;
		//hkprintf("Iteration %d of %d\n", stepCount, options.m_maxIterations);
		if (stepCount == options.m_maxIterations)
		{
			step = hkDemo::DEMO_STOP;
			printf("Elapsed Time: %0.3fs\n", environment.m_frameTimer.getElapsedSeconds());
			printf("Average FPS: %0.3f\n", options.m_maxIterations / environment.m_frameTimer.getElapsedSeconds());
		}
	}

	if ( (step != hkDemo::DEMO_STOP) && (step != hkDemo::DEMO_RESTART) )
	{
		environment.m_frameTimer.updateAndWait( environment );

		// Render the views
		if (graphicsWindowOK)
		{
			renderFrame( environment, demo );

			tickFrame( environment, (step == hkDemo::DEMO_PAUSED) ); 
		}
		else // window may be hidden etc, so strings from demo step may mount up
		{
			clearFrameData( environment );
		}
	}

	// Handy reboot to launcher on some platforms@
	HKG_PAD_BUTTON buttons = HKG_PAD_BUTTON_L1 | HKG_PAD_BUTTON_L2 | HKG_PAD_BUTTON_R1 | HKG_PAD_BUTTON_R2;
	if ( (environment.m_gamePad->getButtonState() & buttons) == buttons )
	{
		step = hkDemo::DEMO_STOP;
	}

	return step;
}

///// COMMON DEFAULT MAIN LINE

int HK_CALL frameworkMain(hkDemoFrameworkOptions& options, const char* startUpDemo)
{
	hkMallocAllocator mallocBase;
	if( !frameworkInitBaseSystem(&mallocBase, options) )
	{
		// If base sys init failed then something badly wrong.
		return -1234;
	}

	// Read demo options from hkdemo.cfg (not supported on Wii currently).
	options.parseFile( "hkdemo.cfg" );
	
	adjustConsoleWindow(options);
	

	int exitCode = 0;
	{
		hkDemoEnvironment environment;
		environment.m_options = &options;
		s_debugEnvironmentHandle = &environment;

		// Init HKG 
		if ( initRendererAndEnv(environment) )
		{
			// Make a demo (usualy the Menu demo)
			hkDemo* demo = frameworkStartDemo( environment, startUpDemo );

			// Main loop
			int stepCount = 0;
			while ( environment.m_window->peekMessages() == HKG_WINDOW_MSG_CONTINUE )
			{
				hkDemo::Result step = frameworkStep( environment, demo, stepCount ); 
				if ( step == hkDemo::DEMO_STOP )
				{
					break;
				}
				else if ( step == hkDemo::DEMO_RESTART )
				{
					delete demo;
					demo = frameworkStartDemo( environment, options.m_defaultDemo );
				}
			}

			// Delete the demo
			if (demo)
			{
				delete demo;
			}

			// Quit HKG
			quitRendererAndEnv(environment);
		}
		exitCode = environment.m_exitCode;
	}
	
	hkResult frameworkQuitResult = frameworkQuitBaseSystem();

	return exitCode | (int)frameworkQuitResult;

}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
