/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */
#ifndef HK_DEMO_FILESYSTEM_H
#define HK_DEMO_FILESYSTEM_H

#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>

class hkDemoFileSystem : public hkFileSystem
{
	public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
		hkDemoFileSystem();
		~hkDemoFileSystem();

		// remove the demo prefix from pathIn, if present
		static void HK_CALL removeDemoBasePath( hkStringBuf& buffer );

		void addSearchPath(const char* p, hkBool32 atFront=false);

		virtual hkStreamWriter* openWriter(const char* name);
		virtual hkStreamReader* openReader(const char* name);
		virtual hkResult listDirectory(const char* basePath, DirectoryListing& listingOut);

		hkFileSystem* m_parent;
		extArray<extStringPtr> m_locations;
};

#endif // HK_DEMO_FILESYSTEM_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
