/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */
#include <Demos/demos.h>
#include <Demos/DemoCommon/DemoFramework/hkDemoConsole.h>

#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>
#include <Common/Base/System/Io/Writer/hkStreamWriter.h>

HK_SINGLETON_IMPLEMENTATION(hkDemoConsole);


#if defined(HK_PLATFORM_UNIX) || defined(HK_PLATFORM_MAC386) || defined(HK_PLATFORM_MACPPC) || defined(HK_PLATFORM_MACARM)
#	include <Common/Base/System/Io/Writer/Posix/hkPosixStreamWriter.h>
	typedef hkPosixStreamWriter DefaultConsoleWriter;
#elif defined(HK_PLATFORM_WIN32)
#	include <Common/Base/System/Io/Writer/Stdio/hkStdioStreamWriter.h>
	typedef hkStdioStreamWriter DefaultConsoleWriter;
#elif defined(HK_PLATFORM_PS3_PPU)
#	include <Common/Base/System/Io/Writer/Stdio/hkStdioStreamWriter.h>
	typedef hkStdioStreamWriter DefaultConsoleWriter;
#else
#	include <Common/Base/System/Io/Writer/Stdio/hkStdioStreamWriter.h>
	typedef hkStdioStreamWriter DefaultConsoleWriter;
#endif
	

hkDemoConsole::hkDemoConsole()
:	m_stdout( new DefaultConsoleWriter( hkFileSystem::STDOUT) ),
	m_stderr( new DefaultConsoleWriter( hkFileSystem::STDERR) )
{
	m_stdout.getStreamWriter()->removeReferenceLockUnchecked();
	m_stderr.getStreamWriter()->removeReferenceLockUnchecked();
}

hkOstream& hkDemoConsole::getStdout()
{
	return m_stdout;
}

hkOstream& hkDemoConsole::getStderr() 
{ 
	return m_stderr;
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
