/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

// precompiled header file
#include <Demos/demos.h>
#include <Demos/DemoCommon/DemoFramework/hkDemo.h>
#include <Common/Base/Monitor/hkMonitorStream.h>
#include <Demos/DemoCommon/DemoFramework/hkDemoFramework.h>
#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>
#include <Demos/DemoCommon/Utilities/Asset/hkAssetManagementUtil.h>
#include <Common/Base/Container/BitField/hkBitField.h>
#include <Common/Base/Spu/Util/hkSpuUtil.h>
#include <Common/Base/Memory/System/hkMemorySystem.h>
#include <Common/Base/Types/Color/hkColor.h>
#include <Common/Visualize/hkDebugDisplay.h>

hkDemoEnvironment::hkDemoEnvironment()	:
	m_window(0), 
	m_displayHandler(0),	
	m_sceneConverter(0),
	m_displayWorld(0),  
	m_textDisplay(0),
	m_gamePad(0),
	m_gamePadB(0),
	m_controlKeyReserved(false),
	m_mousePickingEnabled(true),
	m_shareCameraBetweenViewports(false),
	m_showWorldAxis(false),
	m_inRenderLoop(false),
	m_movieRecorder(0),
	m_options(0),
	m_cpuMhz(
#if HK_PLATFORM_IS_CONSOLE == 0
	2000
#elif defined(HK_PLATFORM_PSP)
	300
#elif defined(HK_PLATFORM_GC)
	450
#elif defined(HK_PLATFORM_XBOX)
	450
#elif defined(HK_PLATFORM_PS3_PPU)
	1600
#elif defined(HK_PLATFORM_XBOX360)
	1600
#elif defined(HK_PLATFORM_MACARM)
    400
#else
#	error please add a mhz rating for this platform
#endif
	),
	m_virtualFrameBufferServer(HK_NULL),
	m_reportingLevel(REPORT_ALL),
	m_exitCode(0)
{
}

// COM-305 : You can use reserve/release in your demos if you want to use the CTRL key (PC only) 
//	         for something different than switching game pads
void hkDemoEnvironment::reserveControlKey()
{
	HK_WARN_ON_DEBUG_IF (m_controlKeyReserved, 0x0, "Reserving CTRL key twice?");
	m_controlKeyReserved = true;
}
void hkDemoEnvironment::releaseControlKey()
{
	HK_WARN_ON_DEBUG_IF (!m_controlKeyReserved, 0x0, "Releasing CTRL key twice?");
	m_controlKeyReserved = false;
}

void hkDemo::getNumTimerStreams( int& numThreadStreams, int& numSpuStreams, int maxThreads ) const
{
	numThreadStreams = 1;
	numSpuStreams = 0;
}

void hkDemo::getTimerStreamInfo( extArray<hkTimerData>& timerStreams, extArray<hkTimerData>& spuStreams, int maxThreads  )
{
	if (maxThreads > 0)
	{
		hkTimerData info;
		info.m_streamBegin = hkMonitorStream::getInstance().getStart();
		info.m_streamEnd = hkMonitorStream::getInstance().getEnd();
		timerStreams.pushBack(info);
	}
}

void hkDemo::resetTimerStreams()
{
	hkMonitorStream::getInstance().reset();
}

hkBool hkDemoEnvironment::getDesiredKeyboardCtrlStateForGamePad( int padIndex ) const
{
	// Normally, pad1 is emulated by holding CTRL (pad0 is emulated when CTRL is not being held).
	// When only one pad is present, we want pad1 to be emulated with no CTRL so we flip the flag.

	bool ctrlState = (	!m_options->m_forceKeyboardGamepad && 
						m_window->hasGamePads() && 
						m_window->getGamePad(0).isConnected() && 
						!m_window->getGamePad(1).isConnected() );

	return ( padIndex ? !ctrlState : ctrlState );
}

hkBool hkDemoEnvironment::wasKeyPressed( int padIndex, HKG_KEYBOARD_VKEY key ) const
{
	const hkgKeyboard& keyboard = m_window->getKeyboard();

	hkBool desiredCtrl = getDesiredKeyboardCtrlStateForGamePad( padIndex );
	hkBool ctrlState = keyboard.getKeyState(HKG_VKEY_CONTROL);

	if ( desiredCtrl == ctrlState )
	{
		return keyboard.wasKeyPressed( key );
	}

	return false;
}

hkBool hkDemoEnvironment::wasKeyReleased( int padIndex, HKG_KEYBOARD_VKEY key ) const
{
	const hkgKeyboard& keyboard = m_window->getKeyboard();

	hkBool desiredCtrl = getDesiredKeyboardCtrlStateForGamePad( padIndex );
	hkBool ctrlState = keyboard.getKeyState(HKG_VKEY_CONTROL);

	if ( desiredCtrl == ctrlState )
	{
		return keyboard.wasKeyReleased( key );
	}

	return false;
}

bool hkDemoEnvironment::wasButtonPressed( unsigned int key ) const
{
	if ( m_gamePad->wasButtonPressed( key))
	{
		return true;
	}
	if ( m_gamePadB->wasButtonPressed(key))
	{
		return true;
	}
	return false;
}
hkBool hkDemoEnvironment::getKeyState( int padIndex, HKG_KEYBOARD_VKEY key ) const
{
	const hkgKeyboard& keyboard = m_window->getKeyboard();

	hkBool desiredCtrl = getDesiredKeyboardCtrlStateForGamePad( padIndex );
	hkBool ctrlState = keyboard.getKeyState(HKG_VKEY_CONTROL);

	if ( desiredCtrl == ctrlState )
	{
		return keyboard.getKeyState( key );
	}

	return false;
}

void hkDemo::setDemoName(const char* name )
{
	m_name = name;
}

void HK_CALL hkDemo::scanDirectoryAndCreateDemosForHavokFiles(const char* path, const char* ending, hkDemoEntry& thisEntry, hkBool recurseFolders, extArray<hkDemoEntry*>& entriesOut )
{
	hkFileSystem& fs = hkFileSystem::getInstance();

	hkFileSystem::DirectoryListing listing(&extAllocator::getInstance());
	fs.listDirectory( path, listing );

	const hkArrayBase<hkFileSystem::Entry>& entries = listing.getEntries();
	extStringBuf fileEnding;

	// enable this if you want to filter for Havok specific layout based filename rules
	//hkAssetManagementUtil::getFileEnding( fileEnding, hkStructureLayout::HostLayoutRules );
	fileEnding += ending;

	for (int i =0; i < entries.getSize(); i++ )
	{
		const hkFileSystem::Entry& entry = entries[i];
		if ( entry.isDir() && recurseFolders )
		{
			hkDemoEntry a;
			a = thisEntry;
			a.m_menuPath = extStringBuf(a.m_menuPath.cString(), "/", entry.name);
			extStringBuf childPath( path, entry.name, "/");
			scanDirectoryAndCreateDemosForHavokFiles( childPath, ending, a, true, entriesOut );
			continue;
		}

		if ( !hkString::endsWith(entry.name, fileEnding) )
		{
			continue;
		}
		hkDemoEntry* a = new hkDemoEntry;
		*a = thisEntry;
		a->m_menuPath = extStringBuf(thisEntry.m_menuPath.cString(), "/", entry.name);
		if (hkStringBuf(path).endsWith("/"))
		{
			a->m_resourcePath = extStringBuf(path, entry.name);
		}
		else
		{
			a->m_resourcePath = extStringBuf(path, "/", entry.name);
		}
		entriesOut.pushBack(a);
	}
}	

void hkDemo::advanceFrame()
{
	hkMemorySystem::getInstance().advanceFrame();
}

hkDemo::Result hkDemo::stepDemo()
{
	// world axis
	if(m_env->m_showWorldAxis)
	{
		hkgWindow*		window=m_env->m_window;
		hkgCamera*		camera=window->getViewport(0)->getCamera();
		float			res[]={0,0,0};	camera->unProjectExact(32,32,0.75f,window->getWidth(),window->getHeight(),res);
		float			res2[]={0,0,0};	camera->unProjectExact(32,32+24,0.75f,window->getWidth(),window->getHeight(),res2);
		hkVector4		org; org.set(res[0],res[1],res[2],0);
		hkVector4		del; del.set(res2[0],res2[1],res2[2],0);
		hkReal			s(org.distanceTo3(del));
		
		HK_DISPLAY_ARROW(org,hkVector4(s,0,0),hkColor::RED);
		HK_DISPLAY_ARROW(org,hkVector4(0,s,0),hkColor::GREEN);
		HK_DISPLAY_ARROW(org,hkVector4(0,0,s),hkColor::BLUE);
	}
	// later bindings override previous ones
	hkInplaceBitField<HKG_KEYBOARD_NUM_VKEYS> keyUsed;
	for( int i = m_keyPressCallbacks.getSize()-1; i >= 0; --i )
	{
		int vkey = m_keyPressCallbacks[i].vkey;
		if( keyUsed.get(vkey) == 0 && m_env->m_window->getKeyboard().wasKeyPressed(HKG_KEYBOARD_VKEY(vkey)) )
		{
			keyUsed.set(vkey);
			m_keyPressCallbacks[i].cb.call();
		}
	}

	for( int i = m_keyHeldCallbacks.getSize()-1; i >= 0; --i )
	{
		int vkey = m_keyHeldCallbacks[i].vkey;
		if( keyUsed.get(vkey) == 0 && m_env->m_window->getKeyboard().getKeyState(HKG_KEYBOARD_VKEY(vkey)) )
		{
			keyUsed.set(vkey);
			m_keyHeldCallbacks[i].cb.call();
		}
	}

	return DEMO_OK;
}

hkDemo::PostStepActions hkDemo::getPostStepActions () const
{
	return DEMO_PSA_NONE;
}

hkDemoEnvironment::ViewportData* hkDemoEnvironment::getViewportData( int windowViewportIndex )
{
	for (int i=0; i < m_viewportData.getSize(); ++i)
	{
		if ( m_viewportData[i].m_windowViewportIndex == windowViewportIndex )
			return &m_viewportData[i];
	}
	return HK_NULL;
}


int hkDemo::bindKeyPressed(int vkey, const char* descr, const KeyPressCallback& cb )
{
	int id = m_keyPressCallbacks.getSize();
	KeyPressCallbackInfo& k = m_keyPressCallbacks.expandOne();
	k.vkey = vkey;
	k.cb = cb;
	k.description = descr;
	return id;
}

int hkDemo::bindKeyHeld(int vkey, const char* descr, const KeyPressCallback& cb )
{
	int id = m_keyHeldCallbacks.getSize();
	KeyPressCallbackInfo& k = m_keyHeldCallbacks.expandOne();
	k.vkey = vkey;
	k.cb = cb;
	k.description = descr;
	return id;
}

int hkToggleBooleanValue(hkBool* b)
{
	*b = !*b;
	return 0;
}

int hkIncrementIntegerValue( int* i )
{
	*i = *i+1;
	return 0;
}

int hkDecrementIntegerValue( int* i )
{
	*i = *i-1;
	return 0;
}

int hkDecrementIntegerValueNonNegative( int* i )
{
	*i = hkMath::max2( *i-1, 0 );
	return 0;
}

int hkDecrementPositiveIntegerValue( int* i )
{
	*i = hkMath::max2( *i-1, 1 );
	return 0;
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
