/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */
#ifndef HKSERIALIZE_LOAD_ASSETS_AS_OBJECTS_H
#define HKSERIALIZE_LOAD_ASSETS_AS_OBJECTS_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultDemo.h>
#include <Demos/DemoCommon/Utilities/FileFinder/FileFinder.h>
#include <Common/Base/System/Io/Writer/hkStreamWriter.h>
#include <Common/Base/System/Io/OStream/hkOStream.h>
#include <Common/Base/System/Error/hkError.h>

class LoadAssetsAsObjectsDemo : public hkDefaultDemo 
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		LoadAssetsAsObjectsDemo(hkDemoEnvironment* env);
		~LoadAssetsAsObjectsDemo();

		Result stepDemo();
private:

	struct FindAssetFilter : public FileFinder::Filter
	{
		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,LoadAssetsAsObjectsDemo::FindAssetFilter);
		hkBool32 isOk( const char* path, hkBool32 isDir );
	};

	struct TeeStream : public hkStreamWriter
	{
		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
		~TeeStream();
		void add(hkStreamWriter* writer);
		int write(const void* buf, int nbytes);
		hkBool isOk() const;
	private:
		hkArray<hkStreamWriter*> m_streams;
	};
	
	class Error: public hkError
	{
	public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
		Error(hkError* nextError, hkOstream& output);
		virtual int message(Message m, int id, const char* description, const char* file, int line);
		virtual void setEnabled( int id, hkBool enabled );
		virtual hkBool isEnabled( int id );
		virtual void enableAll();
		virtual void sectionBegin(int id, const char* sectionName);
		virtual void sectionEnd();

		HK_FORCE_INLINE hkError* getNext() { return m_nextError; }
	private:
		hkRefPtr<hkError> m_nextError;
		hkOstream& m_output;
	};

	static void HK_CALL errorReportFunction(const char* s, void* errorReportObject);

private:

	FindAssetFilter m_assetFilter;
	FileFinder m_fileFinder;
	hkOstream m_fileOutput;
	TeeStream m_log;
	hkOstream m_output;
	Error* m_error;
	int m_iter;
};

#endif // HKSERIALIZE_LOAD_ASSETS_AS_OBJECTS_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
