/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */
#include <Demos/demos.h>
#include <Demos/Common/Test/Feature/LoadAssetsAsObjects/LoadAssetsAsObjectsDemo.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Serialize/Data/Native/hkDataObjectNative.h>
#include <Common/Serialize/Util/hkSerializeUtil.h>

static const char helpString[] = \
"Load demo assests as objects. Shows how to load and destroy objects from binary/xml packfiles and tagfiles.";

LoadAssetsAsObjectsDemo::TeeStream::~TeeStream()
{
	for(int i = 0; i < m_streams.getSize(); ++i )
	{
		m_streams[i]->removeReference();
	}
}

void LoadAssetsAsObjectsDemo::TeeStream::add(hkStreamWriter* writer)
{
	m_streams.pushBack(writer);
	writer->addReference();
}

int LoadAssetsAsObjectsDemo::TeeStream::write(const void* buf, int nbytes)
{
	for(int i = 0; i < m_streams.getSize(); ++i )
	{
		m_streams[i]->write(buf, nbytes);
	}
	return nbytes;
}

hkBool LoadAssetsAsObjectsDemo::TeeStream::isOk() const { return true; }

hkBool32 LoadAssetsAsObjectsDemo::FindAssetFilter::isOk( const char* path, hkBool32 isDir )
{
	hkStringBuf s = path;
	s.lowerCase();
	if(isDir)
	{
		return s.endsWith("/cvs") == false;
	}
	else
	{
		if( s.endsWith(".hkx") == false
			&& s.endsWith(".xml") == false
			&& s.endsWith(".hkt") == false )
		{
			return false;
		}

		return hkSerializeUtil::isLoadable( hkIstream(path).getStreamReader() );
	}
}

LoadAssetsAsObjectsDemo::Error::Error(hkError* nextError, hkOstream& output)
: m_nextError(nextError), m_output(output)
{
	HK_ASSERT(0x19fe0f14, m_nextError);
}

static int warningIdsToProcess[] =
{
	0x3476d70f, /* Could not find the most derived class for virtual object */
	0x43ae1f6b, /* Cannot generate 'alive' object */
	0x7c303834 /* Cannot finish virtual object */
};

int LoadAssetsAsObjectsDemo::Error::message(Message m, int id, const char* description, const char* file, int line)
{
	// eat warnings and reports
	if( m == MESSAGE_WARNING || m == MESSAGE_REPORT )
	{
		if( m == MESSAGE_WARNING 
			&& hkArray<int>(warningIdsToProcess, (int)HK_COUNT_OF(warningIdsToProcess), (int)HK_COUNT_OF(warningIdsToProcess)).indexOf(id) != -1 )
		{
			m_output << "WARNING: " << description << "\n";
		}
		return 0;
	}
	return getNext()->message(m, id, description, file, line);
}

void LoadAssetsAsObjectsDemo::Error::setEnabled( int id, hkBool enabled )
{
	return getNext()->setEnabled(id, enabled);
}

hkBool LoadAssetsAsObjectsDemo::Error::isEnabled( int id )
{
	return getNext()->isEnabled(id);
}

void LoadAssetsAsObjectsDemo::Error::enableAll()
{
	getNext()->enableAll();
}

void LoadAssetsAsObjectsDemo::Error::sectionBegin(int id, const char* sectionName)
{
	getNext()->sectionBegin(id, sectionName);
}

void LoadAssetsAsObjectsDemo::Error::sectionEnd()
{
	getNext()->sectionEnd();
}

LoadAssetsAsObjectsDemo::LoadAssetsAsObjectsDemo(hkDemoEnvironment* env)
: hkDefaultDemo(env), m_fileOutput("LoadedAssetsReport.txt"), m_output(&m_log), m_error(HK_NULL), m_iter(0)
{
	m_fileFinder.addFilter( &m_assetFilter );
	m_fileFinder.addFolder("Resources"); // change this to start at a different root
	m_log.add( hkcout.getStreamWriter() );
	m_log.add( m_fileOutput.getStreamWriter() );

	m_error = new Error(&hkError::getInstance(), m_output);
	hkError::replaceInstance(m_error);
	m_error->addReference();

	hkError::getInstance().setEnabled(0xad904271, false); // update function assert hkpMotion 650r1->660b1 
	hkError::getInstance().setEnabled(0x13821fce, false); // reverse-engineered class numbers
	hkError::getInstance().setEnabled(0x58b3f015, false); // added missing class
		
}

LoadAssetsAsObjectsDemo::~LoadAssetsAsObjectsDemo()
{
	hkError::getInstance().setEnabled(0xad904271, true); // update function assert hkpMotion 650r1->660b1 
	hkError::getInstance().setEnabled(0x13821fce, true); // reverse-engineered class numbers
	hkError::getInstance().setEnabled(0x58b3f015, true); // added missing class

	hkError::replaceInstance(m_error->getNext());
	m_error->getNext()->addReference();
	m_error->removeReference();
}

hkDemo::Result LoadAssetsAsObjectsDemo::stepDemo()
{
	hkStringBuf filename;
	if( m_fileFinder.popNextFile(filename) == HK_NULL )
	{
		return DEMO_STOP;
	}
	const int skip = 0;//397;
	const int stop = int(unsigned(-1)>>1); //skip+1;
	if( m_iter >= stop )
	{
		return DEMO_STOP;
	}

	if( m_iter >= skip )
	{
		m_output << "LOAD >> " << m_iter << "\t" << filename.cString() << "\n";

		hkIstream fileStream(filename);
		hkSerializeUtil::ErrorDetails errRes;
		hkObjectResource* resource = hkSerializeUtil::loadOnHeap(fileStream.getStreamReader(), &errRes);
		
		if(0)
		{
			hkDataWorldNative native;
			const hkClass* contentsClass = hkBuiltinTypeRegistry::getInstance().getClassNameRegistry()->getClassByName(resource->getContentsTypeName());
			native.setContents( resource->getContentsPointer(HK_NULL, hkBuiltinTypeRegistry::getInstance().getLoadedObjectRegistry()), *contentsClass );
			hkStringBuf fname; fname.printf("dump_%04i.txt", m_iter);
			hkSerializeUtil::saveTagfile( native.getContents(), hkOstream(fname.cString()).getStreamWriter(), hkSerializeUtil::SAVE_TEXT_FORMAT );
		}

		if( resource == HK_NULL )
		{
			m_output << "\tFAILED:\t" << errRes.defaultMessage.cString() << "\n";
		}
		else
		{
			resource->removeReference();
		}
		m_output.flush();
	}
	m_iter += 1;
	return DEMO_OK;
}

HK_DECLARE_DEMO(LoadAssetsAsObjectsDemo, HK_DEMO_TYPE_TEST, "Load demo assests as objects", helpString);

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
