/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */
#include <Demos/demos.h>
#include <Demos/Common/Api/Serialize/CustomPatches/CustomPatchesDemo.h>
#include <Common/Serialize/hkSerialize.h>
#include <Common/Serialize/Util/hkSerializeUtil.h>
#include <Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Serialize/Data/Dict/hkDataObjectDict.h>
#include <Common/Serialize/Data/Native/hkDataObjectNative.h>
#include <Common/Serialize/Data/Util/hkDataObjectUtil.h>
#include <Common/Base/Reflection/Registry/hkDynamicClassNameRegistry.h>
#include <Common/Base/Reflection/Registry/hkVtableClassRegistry.h>
#include <Common/Base/Reflection/hkClass.h>
#include <Common/Base/Reflection/hkInternalClassMember.h>
#include <Common/Serialize/Util/hkSerializationCheckingUtils.h>
#include <Common/Serialize/Util/hkVersionCheckingUtils.h>

namespace OldClassVersions
{

	class CustomContainer : public hkReferencedObject
	{
	public:
		HK_DECLARE_REFLECTION();

		class Item
		{
		public:
			HK_DECLARE_REFLECTION();
			hkInt32 m_intMember;
		};

		Item m_classMember;
		hkReal m_realMember;

		CustomContainer() {}
		CustomContainer(hkFinishLoadedObjectFlag f) : hkReferencedObject(f) {}
	};
	//
	// Class CustomContainer::Item
	//
	static const hkInternalClassMember CustomContainer_ItemClass_Members[] =
	{
		{ "intMember", HK_NULL, HK_NULL, hkClassMember::TYPE_INT32, hkClassMember::TYPE_VOID, 0, 0, HK_OFFSET_OF(CustomContainer::Item,m_intMember), HK_NULL }
	};
	const hkClass CustomContainerItemClass(
		"CustomContainerItem",
		HK_NULL, // parent
		sizeof(CustomContainer::Item),
		HK_NULL,
		0, // interfaces
		HK_NULL,
		0, // enums
		reinterpret_cast<const hkClassMember*>(CustomContainer_ItemClass_Members),
		HK_COUNT_OF(CustomContainer_ItemClass_Members),
		HK_NULL, // defaults
		HK_NULL, // attributes
		0, // flags
		0 // version
		);
	HK_REFLECTION_DEFINE_SCOPED_SIMPLE(CustomContainer, CustomContainer, Item, Item);

	//
	// Class CustomContainer
	//
	static const hkInternalClassMember CustomContainerClass_Members[] =
	{
		{ "classMember", &CustomContainerItemClass, HK_NULL, hkClassMember::TYPE_STRUCT, hkClassMember::TYPE_VOID, 0, 0, HK_OFFSET_OF(CustomContainer,m_classMember), HK_NULL },
		{ "realMember", HK_NULL, HK_NULL, hkClassMember::TYPE_REAL, hkClassMember::TYPE_VOID, 0, 0, HK_OFFSET_OF(CustomContainer,m_realMember), HK_NULL }
	};
	extern const hkClass CustomContainerClass;
	const hkClass CustomContainerClass(
		"CustomContainer",
		&hkReferencedObjectClass, // parent
		sizeof(CustomContainer),
		HK_NULL,
		0, // interfaces
		HK_NULL,
		0, // enums
		reinterpret_cast<const hkClassMember*>(CustomContainerClass_Members),
		HK_COUNT_OF(CustomContainerClass_Members),
		HK_NULL, // defaults
		HK_NULL, // attributes
		0, // flags
		0 // version
		);
	HK_REFLECTION_DEFINE_VIRTUAL(CustomContainer, CustomContainer);
}
extern const class hkTypeInfo hkBaseObjectTypeInfo;
extern const class hkTypeInfo hkReferencedObjectTypeInfo;

class CustomPatchesDemo : public hkDefaultDemo
{
	public:

		CustomPatchesDemo( hkDemoEnvironment* env)
			: hkDefaultDemo(env), m_haveRun(false)
		{
		}

		//
		// Display a specified number of spaces
		// for formatting the class member display
		//
		void displayDepth(int depth)
		{
			for(int i=0;i<depth;i++)
			{
				hkcout << "  ";
			}
		}

		//
		// Print out a dump of a dataobject. Simple member values
		// are printed, and all members are listed
		// Members from base classes will also be included
		//
		void displayClass(const hkDataObject& contents, int depth = 0)
		{
			displayDepth(depth);
			hkcout << "Class " << contents.getClass().getName() << " (version " << contents.getClass().getVersion() << ")\n";

			for(int i = 0; i<contents.getClass().getNumMembers();i++)
			{
				hkDataClass::MemberInfo mi;
				contents.getClass().getMemberInfo(i, mi);
				hkDataObject::Value val = contents[mi.m_name];
				
				// Formatting, to get a nicely indented output
				displayDepth(depth);
				
				// Display simple type values
				if(mi.m_type == hkDataObject::TYPE_INT)
				{
					hkcout << mi.m_name << " = " << val.asInt() << "\n";
				}
				else if(mi.m_type == hkDataObject::TYPE_REAL)
				{
					hkcout << mi.m_name << " = " << val.asReal() << "\n";
				}
				else if(mi.m_type & hkDataObject::TYPE_ARRAY)
				{
					hkcout << mi.m_name << " is an array\n"; break;
				}
				else if(mi.m_type == hkDataObject::TYPE_STRUCT)
				{
					// Recursive call for embedded structures
					hkcout << "Struct " << mi.m_name << " ->\n";
					displayClass(val.asObject(), depth + 1);
					displayDepth(depth);
					hkcout << "<-\n";
				}
				else
				{
					// For any other type just print out the name
					hkcout << mi.m_name << "\n";
				}
			}
		}

		//
		// Print the contents of a dataworld
		// (used for demonstration of patching)
		//
		void displayDataWorldContents(const hkDataWorldDict& world, const char* message)
		{
			hkcout << "\n" << message << "\n";
			const hkDataObject contents = world.getContents();
			displayClass(contents);
			hkcout << "\n\nEnd\n\n";
		}

		void generateWorldWithOldClasses(hkDataWorldDict& world)
		{
			// Normally we'd be loading from a tagfile or packfile,
			// which would already have been written using the old
			// class data
			//
			// Here we create the objects directly for clarity.
			//
			// OldClassVersions::CustomContainer is the old class
			// It is a normal C++ object and we can assign values
			// to it
			OldClassVersions::CustomContainer oldContainer;
			oldContainer.m_realMember = -21.0f;
			oldContainer.m_classMember.m_intMember = -17;

			// We copy native->dict because the native world is not mutable.
			hkDynamicClassNameRegistry nameReg;
			hkVtableClassRegistry vtableReg;
			nameReg.registerClass(&hkBaseObjectClass);
			nameReg.registerClass(&hkReferencedObjectClass);
			nameReg.registerClass(&OldClassVersions::CustomContainerItemClass);
			nameReg.registerClass(&OldClassVersions::CustomContainerClass);
			vtableReg.registerVtable(*(void**)&oldContainer, &OldClassVersions::CustomContainerClass);

			// The native data world wraps around a native object (oldContainer in this case)
			// and allows access to it through the DataObject interface. It is not mutable, so
			// we copy it to the DataWorldDict, using all of the class information previously
			// collected
			hkDataWorldNative native;
			native.setClassRegistry(&nameReg);
			native.setVtableRegistry(&vtableReg);
			// Set the oldContainer as the contents of the hkDataWorldNative
			native.setContents(&oldContainer, OldClassVersions::CustomContainerClass);
			// Copy the contents to a new DataWorldDict, that can be modified
			hkDataObjectUtil::deepCopyWorld(world, native);
		}

		void setupRegistries(hkDynamicClassNameRegistry& newNameReg, hkTypeInfoRegistry& typeReg)
		{
			typeReg.registerTypeInfo(&CustomContainerTypeInfo);
			typeReg.registerTypeInfo(&CustomContainerItemTypeInfo);
			typeReg.registerTypeInfo(&hkReferencedObjectTypeInfo);
			typeReg.registerTypeInfo(&hkBaseObjectTypeInfo);
			newNameReg.registerClass(&hkBaseObjectClass);
			newNameReg.registerClass(&hkReferencedObjectClass);
			newNameReg.registerClass(&CustomContainerClass);
			newNameReg.registerClass(&CustomContainerItemClass);
		}

		//
		// The main demo interface. Called repeatedly
		// until the user exits the demo
		//
		Result stepDemo()
		{
			if( m_haveRun )
			{
				return DEMO_OK;
			}

			// Normally all the patches would be added to the global singleton but
			// for this example we'll use a private manager to keep the scope small
			// and not leave useless patches in the global registry
			hkVersionPatchManager patchManager;
			{
				// defined in CustomPatches.cpp. This registers patches with
				// the patch manager
				extern void HK_CALL CustomRegisterPatches(hkVersionPatchManager& patchManager);
				CustomRegisterPatches(patchManager);
			}

			// DataWorldDict stores an object tree in an accessible format
			hkDataWorldDict world;

			// Normally this would be loaded from a file, in this case
			// we generate it dynamically
			generateWorldWithOldClasses(world);

			// For debugging -- print out the contents of the world
			displayDataWorldContents(world, "####################\nBefore versioning:\n####################\n");

			{
				// Create a registry for the up to date versions
				// This is normally handled automatically by the hkVersionPatchManager,
				// although extra classes can always be added dynamically

				// Again, we use local versions instead of the global singleton hkDefaultClassNameRegistry
				// so we don't leave useless patches in the global registry
				hkDynamicClassNameRegistry newNameReg;
				hkTypeInfoRegistry typeReg;

				setupRegistries(newNameReg, typeReg);

				// Patch the objects. hkSerializeUtil will do this automatically
				// when loading a packfile or tagfile if versioning is enabled
				patchManager.applyPatches(world, &newNameReg);

				// The world now contains an up-to-date object with all of the patches
				// applied. We display the contents of the world for debugging purposes

				// Copy the world contents back into a native object. This is allocated from the heap
				// and owned by the hkObjectResource
				hkObjectResource* res = hkDataObjectUtil::toObjectWithRegistry(world.getContents(), &newNameReg, &typeReg);

				// Take the created object out of the hkObjectResource. We are now responsible
				// for management of the object
				CustomContainer* container = res->stealContents<CustomContainer>();
				
				// Container now contains the post-versioning object
				delete container;
				delete res;
			}

			// For demonstration purposes, print out the contents of the hkDataWorldDict
			// (which still contains an implementation of the patched object)
			displayDataWorldContents(world, "####################\nAfter versioning:\n####################\n");
			
			// Only run once per demo
			m_haveRun = true;
			return DEMO_OK;
		}

		hkArray<char> m_reflectionVerify;
		hkArray<char> m_patchesVerify;
		hkBool32 m_haveRun;
};


HK_DECLARE_DEMO(CustomPatchesDemo, HK_DEMO_TYPE_PRIME, "Custom patches examples", "");

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
