/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef ANIMATION_RETARGETING_TIMINGS_DEMO_H
#define ANIMATION_RETARGETING_TIMINGS_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultAnimationDemo.h>

#include <Animation/Animation/Mapper/hkaSkeletonMapper.h>

class hkLoader;
class hkaSkeleton;
class hkaAnimationBinding;
class hkaAnimatedSkeleton;
class hkaMeshBinding;
class hkaDefaultAnimationControl;
class hkaAnimation;

class RetargetingTimingsDemo : public hkDefaultAnimationDemo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO );

		RetargetingTimingsDemo( hkDemoEnvironment* env );

		~RetargetingTimingsDemo();

		Result stepDemo(); 

	private:

		int rigIndexFromAnimationIndex( const char* rigNames[], const char* animationNames[], int animationIndex );

		hkLoader* m_loader;

		hkArray< hkaAnimationBinding* > m_bindings;
		hkArray< hkaSkeleton* > m_skeletons;

		struct MappedCharacter
		{
			HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,RetargetingTimingsDemo::MappedCharacter);
			hkaAnimatedSkeleton* m_character;
			hkQsTransform m_worldFromModel;
			hkInt32 m_color;
			hkaPose* m_pose;
		};

		hkArray< MappedCharacter > m_mappedCharacters;

		int m_numRows;
		int m_numCols;
		int m_numAnimPerChar;

		// Statistics
		int m_numTotalBones;
		int m_numTotalMappedBones;
		int m_numTotalTracks;
};

#endif // ANIMATION_RETARGETING_TIMINGS_DEMO_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
