/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef ANIMATION_RETARGETING_CHAIN_RETARGETING_DEMO_H
#define ANIMATION_RETARGETING_CHAIN_RETARGETING_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultAnimationDemo.h>

#include <Animation/Animation/Mapper/hkaSkeletonMapper.h>

class hkLoader;
class hkaSkeleton;
class hkaAnimatedSkeleton;
class hkaAnimationBinding;
class hkaMeshBinding;
class hkaBoneAttachment;
class hkgDisplayObject;

class ChainRetargetingDemo : public hkDefaultAnimationDemo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO );

		ChainRetargetingDemo( hkDemoEnvironment* env );

		~ChainRetargetingDemo();

		Result stepDemo(); 

	private:

		hkLoader* m_loader;

		hkBool m_drawSkins;
		hkBool m_useReferencePose;

		hkaAnimatedSkeleton* m_animatedSkeleton[ 2 ];
		hkaAnimationBinding* m_binding;

		hkaSkeleton* m_skeleton[ 2 ];
		hkArray< hkRefPtr< hkaMeshBinding > > m_skinBindings[ 2 ];

		hkArray< hkRefPtr< hkaBoneAttachment > > m_attachments[ 2 ];
		hkArray< hkgDisplayObject* > m_attachmentObjects[ 2 ];

		hkaSkeletonMapper* m_mapper;
			
		hkQsTransform m_worldFromModel[ 2 ];
};

#endif // ANIMATION_RETARGETING_CHAIN_RETARGETING_DEMO_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
