/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_DISMEMBERMENT_DEMO_H
#define HK_DISMEMBERMENT_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysicsDemo.h>
#include <Common/Base/Container/PointerMap/hkPointerMap.h>

// Vertex Deformation
#include <Animation/Animation/Deform/Skinning/hkaMeshBinding.h>
#include <Animation/Ragdoll/Instance/hkaRagdollInstance.h>

class hkLoader;
class hkaSkeleton;
class hkaAnimation;
class hkaAnimationBinding;
class hkaAnimatedSkeleton;
class hkaRagdollRigidBodyController;
class hkaDefaultAnimationControl;
class hkaSkeletonMapper;
class hkPseudoRandomGenerator;

// Helper class
class DismembermentDemoRagdollInstanceAndController : public hkReferencedObject
{

	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_ANIMATION);

		enum ControllerType
		{
			NONE,
			KEYFRAMED,
			POWERED
		};

		DismembermentDemoRagdollInstanceAndController( class hkaRagdollInstance* ragdollInstance, const hkaRagdollInstance* originalRagdollInstance, ControllerType type );
		~DismembermentDemoRagdollInstanceAndController();

		void driveToPose( const hkQsTransform* poseLocalSpace, hkQsTransform& worldFromModel, hkReal step );

		ControllerType getType() const;

		const hkaRagdollInstance* getRagdollInstance() const;

		void getPoseWorldSpace( const hkQsTransform* localSpaceIn, hkQsTransform* worldSpaceOut ) const;
	
	private:

		void setBodyKeyframed( hkpRigidBody* rb );
		void setBodyDynamic( hkpRigidBody* rb );


		static int findNearestParentWithRigidBody( int bone, const hkaRagdollInstance* ragdoll );

		int getRagdollRootBone() const;
		void getTransformOfRootRigidBody( hkQsTransform& xform ) const;
	
		hkUint32 calcFilterInfo( hkpRigidBody* body ) const;

		hkRefPtr<hkaRagdollInstance> m_ragdollInstance;
		hkRefPtr<const hkaRagdollInstance> m_originalRagdollInstance;
		hkaRagdollRigidBodyController* m_ragdollRigidBodyController;
		ControllerType m_type;
};

class DismembermentDemo : public hkDefaultPhysicsDemo
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

        DismembermentDemo(hkDemoEnvironment* env);

        ~DismembermentDemo();

        hkDemo::Result stepDemo();

        // Collision Layers used in this demo.
        // By enabling and disabling collisions between these layers, we can tweak the behaviour of the demo
        enum
        {
            LAYER_LANDSCAPE = 1,
            LAYER_RAGDOLL_KEYFRAMED = 2,
            LAYER_RAGDOLL_DYNAMIC = 3,
        };

    private:

		bool isFullyDismembered() const;
		void setupCameraAndShadows();
		static hkReal HK_CALL floatMod( hkReal numerator, hkReal denominator );

		hkQsTransform m_worldFromModel;

		hkaAnimationBinding* m_binding;

		hkaSkeletonMapper* m_ragdollFromAnimation;
		hkaSkeletonMapper* m_animationFromRagdoll;

		const hkaSkeleton* m_animationSkeleton;
		const hkaSkeleton* m_ragdollSkeleton;

		hkaRagdollInstance* m_originalRagdoll;

        class hkLoader* m_loader;

		hkaDefaultAnimationControl* m_control;
		hkaAnimatedSkeleton* m_character;

		hkArray< hkRefPtr<hkaMeshBinding> > m_skinBindings;

		hkPointerMap< class hkpRigidBody*, class hkaMeshBinding* > m_skinFromRigidBody;

		hkArray< DismembermentDemoRagdollInstanceAndController* > m_ragdolls;

		hkPseudoRandomGenerator* m_randomizer;

		bool m_drawRagdoll;
		bool m_drawSkin;
		bool m_drawRagdollSkeleton;
		bool m_drawAnimationSkeleton;
		bool m_autoDismember;
		bool m_explode;
		bool m_useExtractedMotion;
		int m_currentFrame;
		int m_actionFrame;
};

#endif  // HK_DISMEMBERMENT_DEMO_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
