/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HARWARESKINNING_DEMO_H
#define HARWARESKINNING_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultAnimationDemo.h>

// Vertex Deformation
#include <Animation/Animation/Deform/Skinning/hkaMeshBinding.h>

class hkLoader;
class hkaSkeleton;
class hkaAnimation;
class hkaAnimationBinding;
class hkaAnimatedSkeleton;
class hkxMesh;

class HardwareSkinningDemo : public hkDefaultAnimationDemo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO );

		HardwareSkinningDemo( hkDemoEnvironment* env );

		~HardwareSkinningDemo();

		Result stepDemo(); 

	protected:

		int m_origLockFPS;
		bool m_canSkin;

		hkaAnimation* m_animation;

		hkaSkeleton* m_skeleton;

		hkaAnimationBinding* m_binding;

		hkArray< hkRefPtr<hkaMeshBinding> > m_skinBindings;

		hkaAnimatedSkeleton* m_skeletonInstance;

		hkLoader* m_loader;

		class hkgShaderEffectCollection* loadPrecompiledShader();
		class hkgShaderEffectCollection* compileShader();
		void setShader( const hkxMesh* refMesh, hkgShaderEffectCollection* shader);
};

#endif // HARWARESKINNING_DEMO_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
