/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef ADDITIVE_BLENDING_DEMO_H
#define ADDITIVE_BLENDING_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultAnimationDemo.h>
#include <Demos/DemoCommon/Utilities/Animation/AnimationUtils.h>

// Vertex Deformation
#include <Animation/Animation/Deform/Skinning/hkaMeshBinding.h>

// Attachments
#include <Animation/Animation/Rig/hkaBoneAttachment.h>

class hkLoader;
class hkaSkeleton;
class hkaAnimation;
class hkaAnimationBinding;
class hkaAnimatedSkeleton;
class hkaDefaultAnimationControl;

class AdditiveBlendingDemo : public hkDefaultAnimationDemo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO );

		AdditiveBlendingDemo( hkDemoEnvironment* env );

		~AdditiveBlendingDemo();

		Result stepDemo(); 

	private:
		enum
		{
			NUM_ANIMS = 2
		};
		hkLoader* m_loader;

		hkaSkeleton* m_skeleton;

		hkaAnimation* m_animation[NUM_ANIMS];

		hkaAnimationBinding* m_binding[NUM_ANIMS];

		hkaDefaultAnimationControl* m_control[NUM_ANIMS];

		hkaAnimatedSkeleton* m_skeletonInstance;

		hkArray< hkRefPtr<hkaMeshBinding> > m_skinBindings;

		hkArray< hkRefPtr<hkaBoneAttachment> > m_attachments;

		// An array of the graphics meshes that are attached to the skeleton
		hkArray<class hkgDisplayObject*> m_attachmentObjects;
		
};

#endif // ADDITIVE_BLENDING_DEMO_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
